/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock.visitor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.asyncstock.AsyncStockObjectRegister;
import stockmate.asyncstock.visitor.AreaParser;
import stockmate.asyncstock.visitor.BarcodePrefixParser;
import stockmate.asyncstock.visitor.GroupParser;
import stockmate.asyncstock.visitor.InvoiceParser;
import stockmate.asyncstock.visitor.StockParser;
import stockmate.asyncstock.visitor.StockTakeParser;
import stockmate.asyncstock.visitor.SupplierParser;
import stockmate.xml.XMLObjectParser;

public class AsyncRegisterParser
extends StockParser {
    private Map parserMap = new HashMap();

    public AsyncRegisterParser(AsyncStockObjectRegister registerValue) {
        super(registerValue);
        this.putIntoMap(new AreaParser(this.getRegister()));
        this.putIntoMap(new SupplierParser(this.getRegister()));
        this.putIntoMap(new GroupParser(this.getRegister()));
        this.putIntoMap(new InvoiceParser(this.getRegister()));
        this.putIntoMap(new StockTakeParser(this.getRegister()));
        this.putIntoMap(new BarcodePrefixParser(this.getRegister()));
    }

    protected void putIntoMap(XMLObjectParser parser) {
        this.parserMap.put(parser.getTagName(), parser);
    }

    public void parseFromXML(KXmlParser docParser) throws XmlPullParserException, IOException {
        if (docParser.nextTag() == 0) {
            docParser.nextTag();
        }
        docParser.require(2, null, "stock_data");
        docParser.nextTag();
        while (docParser.getEventType() != 3) {
            String name = docParser.getName();
            XMLObjectParser parser = (XMLObjectParser)this.parserMap.get(name);
            if (parser == null) {
                throw new XmlPullParserException("Cannot find parser for:" + name);
            }
            parser.parseFromXML(docParser);
            docParser.nextTag();
        }
        docParser.require(3, null, "stock_data");
    }

    public String getTagName() {
        return "stock_data";
    }
}

