/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock.visitor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.asyncstock.AsyncStockObjectRegister;
import stockmate.asyncstock.SimpleStockGroup;
import stockmate.asyncstock.visitor.GroupChildVisitor;
import stockmate.asyncstock.visitor.ItemVisitor;
import stockmate.asyncstock.visitor.StockParser;

public final class GroupParser
extends StockParser {
    private Map visitorMap = new HashMap();

    public GroupParser(AsyncStockObjectRegister register) {
        super(register);
        this.loadMap(new ItemVisitor());
    }

    private void loadMap(GroupChildVisitor visitor) {
        this.visitorMap.put(visitor.getTagName(), visitor);
    }

    public String getTagName() {
        return "group";
    }

    public void parseFromXML(KXmlParser docParser) throws XmlPullParserException, IOException {
        this.parseGroup(null, docParser);
    }

    public void parseGroup(SimpleStockGroup parentGroup, KXmlParser docParser) throws XmlPullParserException, IOException {
        docParser.require(2, null, this.getTagName());
        SimpleStockGroup newGroup = new SimpleStockGroup(Long.parseLong(docParser.getAttributeValue(null, "id")), docParser.getAttributeValue(null, "label"));
        if (parentGroup != null) {
            newGroup.setParentGroup(parentGroup);
            parentGroup.addSubGroup(newGroup);
        }
        docParser.nextTag();
        while (docParser.getEventType() != 3) {
            String name = docParser.getName();
            if (name.equals("group")) {
                this.parseGroup(newGroup, docParser);
            } else {
                GroupChildVisitor visitor = (GroupChildVisitor)this.visitorMap.get(name);
                if (visitor == null) {
                    throw new XmlPullParserException(name + " Tag is unknown in Stock Group Parser");
                }
                visitor.visit(newGroup, this.getRegister(), docParser);
            }
            docParser.nextTag();
        }
        docParser.require(3, null, this.getTagName());
        this.getRegister().addStockObject(newGroup);
    }
}

