/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock.visitor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.asyncstock.AsyncStockObjectRegister;
import stockmate.asyncstock.SimpleStockInvoice;
import stockmate.asyncstock.visitor.InvoiceChildVisitor;
import stockmate.asyncstock.visitor.InvoiceEntryVisitor;
import stockmate.asyncstock.visitor.StockParser;

public final class InvoiceParser
extends StockParser {
    private Map visitorMap = new HashMap();

    public InvoiceParser(AsyncStockObjectRegister registerValue) {
        super(registerValue);
        this.loadMap(new InvoiceEntryVisitor());
    }

    private void loadMap(InvoiceChildVisitor visitor) {
        this.visitorMap.put(visitor.getTagName(), visitor);
    }

    public String getTagName() {
        return "invoice";
    }

    public void parseFromXML(KXmlParser docParser) throws XmlPullParserException, IOException {
        docParser.require(2, null, this.getTagName());
        SimpleStockInvoice invoice = this.parseInvoice(docParser);
        invoice.setStockArea(this.getRegister().getStockArea(Long.parseLong(docParser.getAttributeValue(null, "area"))));
        invoice.setSupplier(this.getRegister().getSupplier(Long.parseLong(docParser.getAttributeValue(null, "supplier"))));
        docParser.nextTag();
        while (docParser.getEventType() != 3) {
            String name = docParser.getName();
            InvoiceChildVisitor visitor = (InvoiceChildVisitor)this.visitorMap.get(name);
            if (visitor == null) {
                throw new XmlPullParserException(name + " tag is not known in invoice parser.");
            }
            visitor.visit(invoice, this.getRegister(), docParser);
            docParser.nextTag();
        }
        docParser.require(3, null, this.getTagName());
        this.getRegister().addStockObject(invoice);
    }

    public SimpleStockInvoice parseInvoice(KXmlParser parser) throws XmlPullParserException {
        return new SimpleStockInvoice(Long.parseLong(parser.getAttributeValue(null, "id")), parser.getAttributeValue(null, "type"), parser.getAttributeValue(null, "number"));
    }
}

