/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock.visitor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.asyncstock.AsyncStockObjectRegister;
import stockmate.asyncstock.SimpleStockGroup;
import stockmate.asyncstock.SimpleStockItem;
import stockmate.asyncstock.visitor.BarcodeVisitor;
import stockmate.asyncstock.visitor.GroupChildVisitor;
import stockmate.asyncstock.visitor.ItemChildVisitor;
import stockmate.database.interfaces.stock.MeasureUnitI;

public final class ItemVisitor
extends GroupChildVisitor {
    private Map visitorMap = new HashMap();

    public ItemVisitor() {
        this.loadMap(new BarcodeVisitor());
    }

    private void loadMap(ItemChildVisitor visitor) {
        this.visitorMap.put(visitor.getTagName(), visitor);
    }

    public String getTagName() {
        return "item";
    }

    public void visit(SimpleStockGroup parentGroup, AsyncStockObjectRegister register, KXmlParser docParser) throws IOException, XmlPullParserException {
        docParser.require(2, null, this.getTagName());
        SimpleStockItem item = this.parseItem(docParser);
        parentGroup.addStockItem(item);
        docParser.nextTag();
        while (docParser.getEventType() != 3) {
            String name = docParser.getName();
            ItemChildVisitor visitor = (ItemChildVisitor)this.visitorMap.get(name);
            if (visitor == null) {
                throw new XmlPullParserException(name + " tag is not known in item visitor.");
            }
            visitor.visit(item, register, docParser);
            docParser.nextTag();
        }
        docParser.require(3, null, this.getTagName());
    }

    public SimpleStockItem parseItem(KXmlParser parser) throws XmlPullParserException {
        String measure = parser.getAttributeValue(null, "display_unit");
        MeasureUnitI unitI = MeasureUnitHelper.convertToOldSkoolMeasure((MeasureUnit)MeasureUnitHelper.wrangleMeasureUnit((String)measure), (String)MeasureUnitHelper.wrangleMeasureContainer((String)measure), (double)MeasureUnitHelper.wrangleQtyPerUnit((String)measure));
        SimpleStockItem newItem = new SimpleStockItem(Long.parseLong(parser.getAttributeValue(null, "id")), parser.getAttributeValue(null, "label"), unitI);
        return newItem;
    }
}

