/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock.visitor;

import java.io.IOException;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.asyncstock.AsyncStockObjectRegister;
import stockmate.asyncstock.SimpleQuantity;
import stockmate.asyncstock.SimpleStockTake;
import stockmate.asyncstock.SimpleStockTakeEntry;
import stockmate.asyncstock.visitor.StockTakeChildVisitor;

final class StockTakeEntryVisitor
implements StockTakeChildVisitor {
    StockTakeEntryVisitor() {
    }

    public String getTagName() {
        return "entry";
    }

    public void visit(SimpleStockTake parentNode, AsyncStockObjectRegister register, KXmlParser docParser) throws XmlPullParserException, IOException {
        docParser.require(2, null, this.getTagName());
        SimpleStockTakeEntry entry = this.parseFromXML(docParser);
        String actual = docParser.getAttributeValue(null, "actual_qty");
        if (actual != null) {
            entry.setActualQuantity(SimpleQuantity.parseQuantity(actual));
        } else {
            entry.setActualQuantity(null);
        }
        entry.setStockArea(register.getStockArea(Long.parseLong(docParser.getAttributeValue(null, "area"))));
        if (entry.getStockArea() == null) {
            throw new XmlPullParserException("Area is not known, item id:" + docParser.getAttributeValue(null, "item") + ", area id:" + docParser.getAttributeValue(null, "area"));
        }
        entry.setStockItem(register.getStockItem(Long.parseLong(docParser.getAttributeValue(null, "item"))));
        if (entry.getStockItem() == null) {
            throw new XmlPullParserException("Item is not known, item id:" + docParser.getAttributeValue(null, "item"));
        }
        entry.setChecked(Boolean.valueOf(docParser.getAttributeValue(null, "is_checked")));
        docParser.nextTag();
        docParser.require(3, null, this.getTagName());
        parentNode.addStockTakeEntry(entry);
    }

    public SimpleStockTakeEntry parseFromXML(KXmlParser parser) throws XmlPullParserException {
        return new SimpleStockTakeEntry(Long.parseLong(parser.getAttributeValue(null, "id")), SimpleQuantity.parseQuantity(parser.getAttributeValue(null, "expected_qty")));
    }
}

