/*
 * Decompiled with CFR 0.152.
 */
package stockmate.asyncstock.visitor;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.asyncstock.AsyncStockObjectRegister;
import stockmate.asyncstock.SimpleStockTake;
import stockmate.asyncstock.visitor.StockParser;
import stockmate.asyncstock.visitor.StockTakeChildVisitor;
import stockmate.asyncstock.visitor.StockTakeEntryVisitor;

public final class StockTakeParser
extends StockParser {
    private Map visitors;
    private DateFormat dateFormat;

    public StockTakeParser(AsyncStockObjectRegister registerValue) {
        this(registerValue, null);
    }

    public StockTakeParser(AsyncStockObjectRegister registerValue, DateFormat format) {
        super(registerValue);
        this.dateFormat = format;
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        }
        this.visitors = new HashMap();
        this.loadVisitor(new StockTakeEntryVisitor());
    }

    public String getTagName() {
        return "stocktake";
    }

    private void loadVisitor(StockTakeChildVisitor visitor) {
        this.visitors.put(visitor.getTagName(), visitor);
    }

    public void parseFromXML(KXmlParser docParser) throws XmlPullParserException, IOException {
        docParser.require(2, null, this.getTagName());
        SimpleStockTake take = this.parseSimpleStockTake(docParser);
        docParser.nextTag();
        while (docParser.getEventType() != 3) {
            StockTakeChildVisitor visitor = (StockTakeChildVisitor)this.visitors.get(docParser.getName());
            if (visitor == null) {
                throw new XmlPullParserException("Tag:" + docParser.getName() + " unknown in SimpleStockTakeParser");
            }
            visitor.visit(take, this.getRegister(), docParser);
            docParser.nextTag();
        }
        docParser.require(3, null, this.getTagName());
        this.getRegister().addStockObject(take);
    }

    private SimpleStockTake parseSimpleStockTake(KXmlParser docParser) throws XmlPullParserException {
        Date stockTakeDate = null;
        try {
            String dateString = docParser.getAttributeValue(null, "date");
            stockTakeDate = this.dateFormat.parse(dateString);
        }
        catch (ParseException ex) {
            throw new XmlPullParserException("StockTake Date format is invalid.", (XmlPullParser)docParser, (Throwable)ex);
        }
        return new SimpleStockTake(Long.parseLong(docParser.getAttributeValue(null, "id")), stockTakeDate, Boolean.valueOf(docParser.getAttributeValue(null, "is_live")));
    }
}

