/*
 * Decompiled with CFR 0.152.
 */
package stockmate.device.scanner;

import stockmate.device.scanner.AbstractScannerManager;
import stockmate.device.scanner.NoScannerException;
import stockmate.device.scanner.ScannerListener;
import stockmate.device.scanner.ScannerManager;
import stockmate.device.scanner.SocketscanManager;
import stockmate.device.scanner.SymbolManager;
import stockmate.device.scanner.UnableToInitException;

public final class Scanner {
    public static final int NO_SCANNER = 0;
    public static final int SYMBOL_SCANNER = 1;
    public static final int SOCKETSCAN_SCANNER = 2;
    private static ScannerManager manager = null;
    private static int currentType = 0;

    private Scanner() {
    }

    public static void initialise(int scannerType) throws UnableToInitException {
        if (scannerType != 1 && scannerType != 2 && scannerType != 0) {
            throw new IllegalArgumentException("invalid scannerType!");
        }
        if (scannerType == currentType) {
            return;
        }
        AbstractScannerManager newManager = null;
        if (scannerType == 1) {
            newManager = new SymbolManager();
            currentType = 1;
        } else if (scannerType == 2) {
            newManager = new SocketscanManager();
            currentType = 2;
        } else {
            currentType = 0;
        }
        if (manager != null) {
            manager.stop();
        }
        manager = newManager;
    }

    public static void stop() {
        try {
            Scanner.initialise(0);
        }
        catch (UnableToInitException unableToInitException) {
            // empty catch block
        }
    }

    public static int getType() {
        return currentType;
    }

    public static boolean isValid() {
        return manager != null;
    }

    public static void setScannerListener(ScannerListener listener) throws NoScannerException {
        if (manager == null) {
            throw new NoScannerException("uninitialised scanner!");
        }
        manager.setScannerListener(listener);
    }

    public static void cancelScannerListener() throws NoScannerException {
        if (manager == null) {
            throw new NoScannerException("uninitialised scanner!");
        }
        manager.cancelScannerListener();
    }
}

