/*
 * Decompiled with CFR 0.152.
 */
package stockmate.device.scanner;

import au.com.ordermate.OrderMateLog;
import stockmate.device.scanner.AbstractScannerManager;
import stockmate.device.scanner.UnableToInitException;
import symbol.ScanReadInfo;
import symbol.Scanner;
import symbol.ScannerDevice;
import symbol.ScannerOperationException;
import symbol.Symbol;
import symbol.TextData;

public class SymbolManager
extends AbstractScannerManager {
    private static boolean inited = false;
    private Scanner scanner;
    private ScanReadInfo currentRead;

    public SymbolManager() throws UnableToInitException {
        try {
            if (!inited) {
                Symbol.initPackage();
                inited = true;
            }
        }
        catch (NoClassDefFoundError e) {
            OrderMateLog.LOG.error((Object)"Cannot load symbol scanner", (Throwable)e);
            String message = "Could not start Symbol scanner.\nUnable to find class.";
            throw new UnableToInitException(message);
        }
        catch (UnsatisfiedLinkError e) {
            OrderMateLog.LOG.error((Object)"Cannot load symbol scanner", (Throwable)e);
            String message = "Could not start Symbol scanner.\nUnable to find library.";
            throw new UnableToInitException(message);
        }
        ScannerDevice[] deviceList = Symbol.getScannerDeviceList();
        if (deviceList == null || deviceList.length == 0) {
            String message = "Could not start Symbol scanner.\nNo scanner is present.";
            throw new UnableToInitException(message);
        }
        try {
            this.scanner = new Scanner(deviceList[0]);
            this.scanner.enable();
        }
        catch (Exception e) {
            String message = "Could not start Symbol scanner.\nCould not initiate scanner.";
            throw new UnableToInitException(message);
        }
    }

    public void stop() {
        this.scanner.cancelRead(this.currentRead);
        this.scanner.cancelAll();
        try {
            this.scanner.disable();
            this.scanner.dispose();
        }
        catch (ScannerOperationException scannerOperationException) {
            // empty catch block
        }
    }

    public void readNotify(ScanReadInfo readData) {
        if (readData.getStatus() == 2) {
            String barcode = ((TextData)readData.data).text;
            this.dispatchScan(barcode);
        }
    }
}

