/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.login.admin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class AdminPanel
extends JPanel
implements ActionListener {
    private static final Insets insets = new Insets(1, 1, 1, 1);
    private JButton aboutButton;
    private JButton exitButton;
    private JButton ipAddressButton;
    private JButton scannerButton;
    public final Signal about = Signals.createSignal();
    public final Signal exit = Signals.createSignal();
    public final Signal ipAddress = Signals.createSignal();

    public AdminPanel() {
        JPanel header = new JPanel();
        header.setLayout(new FlowLayout(0));
        header.add(new JLabel("Admin Options:"));
        this.aboutButton = this.constructButton("About", null);
        this.exitButton = this.constructButton("Exit", null);
        this.ipAddressButton = this.constructButton("Server IP Address", null);
        DefaultScrollPaneModel model = new DefaultScrollPaneModel(1, 7);
        model.addComponent((Component)this.ipAddressButton);
        model.addComponent((Component)this.aboutButton);
        model.addComponent((Component)this.exitButton);
        this.setLayout(new BorderLayout());
        this.add("North", header);
        this.add("Center", (Component)new CustomScrollPane((CustomScrollPaneModel)model));
    }

    private JButton constructButton(String label, String icon) {
        JButton button = new JButton();
        if (label != null) {
            button.setText(label);
        }
        if (icon != null) {
            button.setIcon(new ImageIcon(this.getClass().getResource(icon)));
        }
        button.setMargin(insets);
        button.addActionListener(this);
        return button;
    }

    public void display() {
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.aboutButton) {
            this.about.emit();
        } else if (source == this.exitButton) {
            this.exit.emit();
        } else if (source == this.ipAddressButton) {
            this.ipAddress.emit();
        }
    }
}

