/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.login.admin.scanner;

import javax.swing.JMenuBar;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import pocketmate.Configuration;
import pocketmate.gui.dialogs.Dialogs;
import pocketmate.gui.navbar.NavBar;
import stockmate.application.ApplicationContext;
import stockmate.application.DisplayController;
import stockmate.device.scanner.Scanner;
import stockmate.device.scanner.UnableToInitException;
import stockmate.gui.display.states.login.admin.scanner.ScannerSetupPanel;

public class ScannerSetup {
    private ScannerSetupPanel gui;
    private NavBar navBar;
    public final Signal complete = Signals.createSignal();

    public ScannerSetup() {
        this.gui = new ScannerSetupPanel();
        this.navBar = new NavBar();
        this.navBar.ok.connect((Object)this, "gotOk");
        this.navBar.cancel.connect((Object)this, "gotCancel");
    }

    public void start() {
        this.gui.display(Scanner.getType());
        DisplayController dc = ApplicationContext.getDisplayController();
        dc.displayWaitIcon();
        dc.setDisplay(this.gui, (JMenuBar)this.navBar);
        dc.removeWaitIcon();
    }

    public void gotOk() {
        if (this.gui.getType() != Scanner.getType()) {
            try {
                Scanner.initialise(this.gui.getType());
                if (this.gui.getType() == 1) {
                    Configuration.current.setScannerType("symbol");
                } else if (this.gui.getType() == 2) {
                    Configuration.current.setScannerType("socketscan");
                } else {
                    Configuration.current.setScannerType("none");
                }
                this.complete.emit();
            }
            catch (UnableToInitException e) {
                Dialogs.displayCriticalDialog((String)"Setup Error", (String)e.getMessage());
            }
        } else {
            this.complete.emit();
        }
    }

    public void gotCancel() {
        this.complete.emit();
    }
}

