/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.login.userselect;

import au.com.ordermate.util.IconLoader;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import pocketmate.gui.dialogs.Dialogs;
import pocketmate.gui.navbar.NavBar;
import stockmate.application.ApplicationContext;
import stockmate.application.DisplayController;
import stockmate.gui.display.states.login.userselect.UserSelectPanel;
import stockmate.login.StockItLoginManager;

public class UserSelect {
    private UserSelectPanel gui;
    private NavBar navBar;
    private JButton refreshButton;
    public final Signal cancel = Signals.createSignal();
    public final Signal complete = Signals.createSignal();
    public final Signal refresh = Signals.createSignal();

    public UserSelect() {
        this.gui = new UserSelectPanel();
        this.navBar = new NavBar();
        this.navBar.cancel.connect((Object)this.cancel, "emit");
        this.navBar.ok.connect((Object)this, "gotPassword");
        this.refreshButton = new JButton();
        this.refreshButton.setIcon(IconLoader.get((String)"/pocketmate/images/pmh_refresh.png"));
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UserSelect.this.refresh.emit();
            }
        });
        this.navBar.setComponent((JComponent)this.refreshButton, "Refresh ");
        this.refresh.connect((Object)this, "gotRefresh");
    }

    public void startUserSelect() {
        StockItLoginManager loginManager = (StockItLoginManager)ApplicationContext.getLoginManager();
        loginManager.logoutCurrentUser();
        if (!loginManager.canLogin()) {
            boolean choice = Dialogs.displayChoiceDialog((String)"User information has not been downloaded.\nWould you like to download now?", (String)"Yes", (String)"No");
            if (choice) {
                this.downloadUserInformation();
            } else {
                this.cancel.emit();
            }
        } else {
            DisplayController dc = ApplicationContext.getDisplayController();
            dc.displayWaitIcon();
            this.gui.display();
            dc.setDisplay(this.gui, (JMenuBar)this.navBar);
            dc.removeWaitIcon();
        }
    }

    private void downloadUserInformation() {
        this.gotRefresh();
        if (!((StockItLoginManager)ApplicationContext.getLoginManager()).canLogin()) {
            boolean choice = Dialogs.displayChoiceDialog((String)"User information cannot be downloaded.\nRetry?", (String)"Yes", (String)"No");
            if (choice) {
                this.downloadUserInformation();
            } else {
                this.cancel.emit();
            }
        } else {
            this.startUserSelect();
        }
    }

    public void gotPassword() {
        String password = this.gui.getPin();
        String name = this.gui.getSelectedUser();
        if (ApplicationContext.getLoginManager().loginAsUser(name, password)) {
            this.complete.emit();
        } else {
            Dialogs.displayWarningDialog(null, (String)"Invalid PIN");
            this.gui.display();
        }
    }

    public void gotRefresh() {
        ApplicationContext.getDisplayController().displayWaitIcon();
        ((StockItLoginManager)ApplicationContext.getLoginManager()).synchroniseUserData();
        ApplicationContext.getDisplayController().removeWaitIcon();
        this.gui.display();
    }
}

