/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.login.userselect;

import au.com.ordermate.util.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.keypad.Keypad;
import ordermate.gui.keypad.KeypadModel;
import ordermate.gui.keypad.StringModel;
import stockmate.application.ApplicationContext;
import stockmate.login.StockItLoginManager;

public class UserSelectPanel
extends JPanel {
    private static final Insets insets = new Insets(10, 20, 10, 20);
    private Keypad keypad;
    private JComboBox userCombo;

    public UserSelectPanel() {
        Color white = new Color(255, 255, 255);
        Color black = new Color(0, 0, 0);
        JPanel south = new JPanel(new FlowLayout(1));
        south.setBackground(white);
        JPanel north = new JPanel();
        north.setLayout(new FlowLayout(0));
        this.userCombo = new JComboBox();
        north.add(this.userCombo);
        this.userCombo.setMaximumRowCount(5);
        this.userCombo.setPreferredSize(new Dimension(180, 25));
        JLabel dataLabel = new JLabel("Enter PIN");
        dataLabel.setForeground(black);
        dataLabel.setBackground(new Color(255, 2, 233));
        south.add(dataLabel);
        this.keypad = new Keypad(dataLabel, 5);
        this.keypad.setDecimalButtonVisible(false);
        this.keypad.setModel((KeypadModel)new StringModel());
        this.keypad.setRenderer(Keypad.PASSWORD_RENDERER);
        this.keypad.setButtonInsets(insets);
        this.keypad.setBackIcon(IconLoader.get((String)"/pocketmate/images/arrow_left.png"));
        JPanel center = new JPanel();
        center.add((Component)this.keypad);
        this.setLayout(new BorderLayout());
        this.add("North", north);
        this.add("Center", center);
        this.add("South", south);
        this.revalidate();
        this.setBackground(white);
        north.setBackground(white);
        center.setBackground(white);
        this.keypad.setBackground(white);
    }

    public void display() {
        this.userCombo.setModel(new DefaultComboBoxModel<String>(((StockItLoginManager)ApplicationContext.getLoginManager()).getUsernames()));
        this.keypad.resetModel();
    }

    public String getPin() {
        return this.keypad.getValueAsString();
    }

    public String getSelectedUser() {
        return (String)this.userCombo.getSelectedItem();
    }
}

