/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock;

import javax.swing.JMenuBar;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import pocketmate.gui.dialogs.Dialogs;
import pocketmate.gui.navbar.NavBar;
import stockmate.application.ApplicationContext;
import stockmate.application.DisplayController;
import stockmate.database.interfaces.stock.StockObjectRegister;
import stockmate.database.interfaces.stock.StockObjectRegisterVendor;
import stockmate.gui.display.states.stock.StockControlPanel;
import stockmate.gui.display.states.stock.receive.ReceiveStock;
import stockmate.gui.display.states.stock.stocktake.Stocktake;

public class StockControl {
    private StockControlPanel gui;
    private NavBar navBar;
    private Stocktake stocktake;
    private ReceiveStock receiveStock;
    public final Signal complete = Signals.createSignal();

    public StockControl() {
        this.gui = new StockControlPanel();
        this.navBar = new NavBar();
        this.navBar.setCancelButtonVisible(false);
        this.stocktake = new Stocktake();
        this.receiveStock = new ReceiveStock();
        this.stocktake.complete.connect((Object)this, "gotStockTakeDone");
        this.stocktake.stockTakingDone.connect((Object)this.stocktake, "start");
        this.receiveStock.complete.connect((Object)this, "gotReceiveStockDone");
        this.gui.stocktake.connect((Object)this, "gotStockTake");
        this.gui.receive.connect((Object)this, "gotReceiveStock");
        this.navBar.ok.connect(this.complete);
    }

    public void start() {
        DisplayController dc = ApplicationContext.getDisplayController();
        dc.displayWaitIcon();
        dc.setDisplay(this.gui, (JMenuBar)this.navBar);
        dc.removeWaitIcon();
    }

    public void gotStockTake() {
        if (this.ensureStockDataSynchronised(0)) {
            this.stocktake.start();
        }
    }

    public void gotReceiveStock() {
        if (this.ensureStockDataSynchronised(0)) {
            this.receiveStock.start();
        }
    }

    public void gotStockTakeDone() {
        if (this.ensureStockDataSynchronised(0)) {
            this.start();
        }
    }

    public void gotReceiveStockDone() {
        this.start();
    }

    private boolean ensureStockDataSynchronised(int attempt) {
        boolean choice;
        StockObjectRegister register = StockObjectRegisterVendor.getStockObjectRegister();
        ApplicationContext.getDisplayController().displayWaitIcon();
        register.updateStockData();
        ApplicationContext.getDisplayController().removeWaitIcon();
        if (!register.isStockDataSynchronised() && (choice = Dialogs.displayChoiceDialog((String)this.getConfirmString(attempt), (String)"Yes", (String)"No"))) {
            this.ensureStockDataSynchronised(attempt + 1);
        }
        return register.isStockDataSynchronised();
    }

    private String getConfirmString(int attempt) {
        if (attempt <= 0) {
            return "Stock Data needs to be synchronised before you proceed. Try to update now?";
        }
        if (attempt < 3) {
            return "Couldn't synchronise data. Try again?";
        }
        return "There may be something wrong with your connection.\nCheck that you are in a connected zone, the Server is on and all network settings are correct. Try again?";
    }
}

