/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.DefaultScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class StockControlPanel
extends JPanel
implements ActionListener {
    private static final Insets insets = new Insets(1, 1, 1, 1);
    private JButton stocktakeButton;
    private JButton currentLevelButton;
    private JButton receiveButton;
    public final Signal stocktake = Signals.createSignal();
    public final Signal currentLevel = Signals.createSignal();
    public final Signal receive = Signals.createSignal();
    public final Signal update = Signals.createSignal();

    public StockControlPanel() {
        JPanel header = new JPanel();
        header.setLayout(new FlowLayout(0));
        header.add(new JLabel("Stock Control:"));
        this.stocktakeButton = this.constructButton("Stocktake", null);
        this.currentLevelButton = this.constructButton("Current Levels", null);
        this.receiveButton = this.constructButton("Receive", null);
        DefaultScrollPaneModel model = new DefaultScrollPaneModel(2, 7);
        model.addComponent((Component)this.stocktakeButton);
        model.addComponent((Component)this.receiveButton);
        this.setLayout(new BorderLayout());
        this.add("North", header);
        this.add("Center", (Component)new CustomScrollPane((CustomScrollPaneModel)model));
    }

    private JButton constructButton(String label, String icon) {
        JButton button = new JButton();
        if (label != null) {
            button.setText(label);
        }
        if (icon != null) {
            button.setIcon(new ImageIcon(this.getClass().getResource(icon)));
        }
        button.setMargin(insets);
        button.addActionListener(this);
        return button;
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.stocktakeButton) {
            this.stocktake.emit();
        } else if (source == this.currentLevelButton) {
            this.currentLevel.emit();
        } else if (source == this.receiveButton) {
            this.receive.emit();
        }
    }
}

