/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.receive;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import pocketmate.gui.dialogs.Dialogs;
import stockmate.database.interfaces.stock.QuantityI;
import stockmate.database.interfaces.stock.StockInvoiceEntryI;
import stockmate.database.interfaces.stock.StockItemI;
import stockmate.database.interfaces.stock.StockObjectRegisterVendor;

class InvoiceEntryPanel
extends JPanel
implements ActionListener {
    public final Signal deletePressed = Signals.createSignal((Class)(class$stockmate$database$interfaces$stock$StockInvoiceEntryI == null ? (class$stockmate$database$interfaces$stock$StockInvoiceEntryI = InvoiceEntryPanel.class$("stockmate.database.interfaces.stock.StockInvoiceEntryI")) : class$stockmate$database$interfaces$stock$StockInvoiceEntryI), (String)"entry");
    private static final Insets insets = new Insets(1, 1, 1, 1);
    private static final Color selected = new Color(20, 210, 210);
    private StockInvoiceEntryI entry = null;
    private boolean isSelected = false;
    private static InvoiceEntryPanel selectedPanel;
    public static final Signal reset;
    private JLabel nameLabel = new JLabel();
    private JLabel amountLabel;
    private JButton quantityButton;
    private JButton deleteButton;
    static /* synthetic */ Class class$stockmate$database$interfaces$stock$StockInvoiceEntryI;

    public InvoiceEntryPanel() {
        this.nameLabel.setName("nameLabel");
        this.amountLabel = new JLabel();
        this.amountLabel.setName("amountLabel");
        this.quantityButton = new JButton(IconLoader.get((String)"/pocketmate/images/pmh_calc.png"));
        this.quantityButton.setName("qtyBut");
        this.quantityButton.setMargin(insets);
        this.quantityButton.setOpaque(false);
        this.quantityButton.setBorderPainted(false);
        this.quantityButton.addActionListener(this);
        this.deleteButton = new JButton(IconLoader.get((String)"/pocketmate/images/CANCEL ICON_POCKETMATE.png"));
        this.deleteButton.setName("deleteBut");
        this.deleteButton.setMargin(insets);
        this.deleteButton.setOpaque(false);
        this.deleteButton.setBorderPainted(false);
        this.deleteButton.addActionListener(this);
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 5)));
        this.add((Component)this.nameLabel, new Rectangle(0, 1, 6, 3));
        this.add((Component)this.amountLabel, new Rectangle(6, 1, 2, 3));
        this.add((Component)this.quantityButton, new Rectangle(8, 1, 1, 3));
        this.add((Component)this.deleteButton, new Rectangle(9, 1, 1, 3));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                InvoiceEntryPanel.this.setSelected(true);
            }
        });
        if (selectedPanel == null) {
            this.setSelected(true);
        }
    }

    public StockInvoiceEntryI getEntry() {
        return this.entry;
    }

    public void setEntry(StockInvoiceEntryI theEntry) {
        this.entry = theEntry;
        this.nameLabel.setText(this.entry.getStockItem().getLabel());
        QuantityI amount = StockObjectRegisterVendor.getStockObjectRegister().createQuantity(this.entry.getNumReceived());
        this.amountLabel.setText(amount.getAmountString());
    }

    public Color getBackground() {
        if (this.isSelected) {
            return selected;
        }
        return super.getBackground();
    }

    public void setSelected(boolean newSelected) {
        if (newSelected) {
            if (selectedPanel != null) {
                selectedPanel.setSelected(false);
            }
            selectedPanel = this;
            this.isSelected = true;
        } else {
            selectedPanel = null;
            this.isSelected = false;
        }
        this.repaint();
    }

    public void editAmount() {
        this.quantityButton.doClick();
    }

    public static InvoiceEntryPanel getSelectedPanel() {
        return selectedPanel;
    }

    public static void setSelectedPanel(InvoiceEntryPanel panel) {
        if (selectedPanel != null) {
            selectedPanel.setSelected(false);
        }
        selectedPanel = panel;
    }

    private void changeAmount() {
        double amount = Dialogs.getStockItemDouble((StockItemI)this.entry.getStockItem(), (String)"Amount:", (double)this.entry.getNumReceived());
        StockItemI item = Dialogs.getStockItemJustSelected();
        if (amount != Double.MIN_VALUE) {
            StockObjectRegisterVendor.getStockObjectRegister().setInvoiceEntryParameters(this.entry, amount, item);
            this.amountLabel.setText(String.valueOf(this.entry.getNumReceived()));
            this.nameLabel.setText(this.entry.getStockItem().getLabel());
        }
        reset.emit();
    }

    private void deleteEntry() {
        this.deletePressed.emit((Object)this.entry);
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.quantityButton) {
            this.changeAmount();
        } else if (source == this.deleteButton) {
            this.deleteEntry();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        reset = Signals.createSignal();
    }
}

