/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.receive;

import java.awt.Component;
import java.util.List;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import stockmate.database.interfaces.stock.StockInvoiceEntryI;
import stockmate.database.interfaces.stock.StockInvoiceI;
import stockmate.database.interfaces.stock.StockObjectRegisterVendor;
import stockmate.gui.display.states.stock.receive.InvoiceEntryPanel;

public class InvoiceModel
extends AbstractScrollPaneModel {
    public final Signal entryDeleted = Signals.createSignal();
    public static final int NUM_ROWS = 7;
    private StockInvoiceI invoice;
    private InvoiceEntryPanel[] panels = new InvoiceEntryPanel[7];

    public InvoiceModel() {
        super(1, 7);
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i] = new InvoiceEntryPanel();
            this.panels[i].deletePressed.connect((Object)this, "gotDeletePressed");
        }
    }

    public List getEntries() {
        return this.invoice.getEntries();
    }

    public void gotDeletePressed(StockInvoiceEntryI entry) {
        StockObjectRegisterVendor.getStockObjectRegister().removeInvoiceEntry(this.invoice, entry);
        this.entryDeleted.emit();
    }

    public void setInvoice(StockInvoiceI invoice) {
        if (invoice == null) {
            throw new IllegalArgumentException("Invoice cannot be null!");
        }
        this.invoice = invoice;
        InvoiceEntryPanel.setSelectedPanel(this.panels[0]);
    }

    public StockInvoiceI getInvoice() {
        return this.invoice;
    }

    public void addEntry(StockInvoiceEntryI entry) {
        StockObjectRegisterVendor.getStockObjectRegister().addInvoiceEntry(this.invoice, entry);
    }

    public int getPageNum(StockInvoiceEntryI entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry cannot be null.");
        }
        int index = this.invoice.getEntries().indexOf(entry);
        if (index == -1) {
            return -1;
        }
        return index / 7;
    }

    public int getSize() {
        if (this.invoice != null) {
            return this.invoice.getEntries().size();
        }
        return 0;
    }

    protected Component getComponent(int index) {
        if (index < 0 || index >= this.getSize()) {
            String s = index + " is < 0 or >= " + this.getSize();
            throw new ArrayIndexOutOfBoundsException(s);
        }
        StockInvoiceEntryI entry = (StockInvoiceEntryI)this.invoice.getEntries().get(index);
        int numPages = index / 7;
        int i = index - numPages * 7;
        this.panels[i].setEntry(entry);
        return this.panels[i];
    }

    public void setColumns(int columns) {
    }

    public void setRowsPerPage(int rows) {
    }
}

