/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.receive;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ordermate.OrderMate;
import ordermate.gui.InputAdapter;
import ordermate.gui.InputAdapterFactory;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.PageChangeEvent;
import ordermate.gui.scroll.PageChangeListener;
import pocketmate.gui.dialogs.Dialogs;
import stockmate.database.interfaces.stock.StockAreaI;
import stockmate.database.interfaces.stock.StockInvoiceEntryI;
import stockmate.database.interfaces.stock.StockItemI;
import stockmate.database.interfaces.stock.StockObjectRegister;
import stockmate.database.interfaces.stock.StockObjectRegisterVendor;
import stockmate.database.interfaces.stock.StockSupplierI;
import stockmate.device.scanner.ScannerListener;
import stockmate.gui.display.states.stock.BarcodeDocument;
import stockmate.gui.display.states.stock.receive.InvoiceEntryPanel;
import stockmate.gui.display.states.stock.receive.InvoiceModel;

public class InvoicePanel
extends JPanel
implements ScannerListener,
ActionListener {
    private CustomScrollPane scrollPane;
    private InvoiceModel model;
    private JTextField barcodeField;
    private JButton addButton;
    private JPanel barcodePanel;
    private JComboBox areaCombo;
    private JComboBox supplierCombo;
    private PageChangeListener currentPageListener;

    public InvoicePanel() {
        this.setName("invoicePanel");
        this.model = new InvoiceModel();
        this.model.entryDeleted.connect((Object)this, "gotEntryDeleted");
        BarcodeDocument doc = new BarcodeDocument();
        doc.barcodeInput.connect((Object)this, "barcodeValueChanged");
        this.areaCombo = new JComboBox();
        this.supplierCombo = new JComboBox();
        this.barcodeField = new JTextField(doc, "", 10);
        this.barcodeField.addActionListener(this);
        this.barcodeField.setName("barcodeField");
        this.barcodePanel = new JPanel();
        this.barcodePanel.setLayout(new FlowLayout(0));
        this.barcodePanel.add(new JLabel("Barcode:"));
        this.barcodePanel.add(this.barcodeField);
        this.addButton = new JButton(IconLoader.get((String)"/pocketmate/images/pmh_calc_plus.png"));
        this.barcodePanel.add(this.addButton);
        this.addButton.setName("addEntry");
        this.addButton.addActionListener(this);
        InvoiceEntryPanel.reset.connect((Object)this, "resetBarcodeField");
        try {
            InputAdapter adapter = InputAdapterFactory.getAdapter();
            if (adapter != null) {
                adapter.barcodeInput.connect((Object)this, "gotBarcode");
            }
        }
        catch (IllegalStateException ex) {
            OrderMate.LOG.info((Object)"No input adapter is specified, will not listen to barcodes through adapter.");
        }
    }

    public void newInvoice() {
        this.model.setInvoice(StockObjectRegisterVendor.getStockObjectRegister().createInvoice());
    }

    public void display() {
        if (this.scrollPane != null) {
            this.scrollPane.removePageChangeListener(this.currentPageListener);
        }
        this.barcodeField.setText("");
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.currentPageListener = new PageChangeListener(){

            public void pageChanged(PageChangeEvent e) {
                InvoicePanel.this.barcodeField.requestFocus();
            }
        };
        this.scrollPane.addPageChangeListener(this.currentPageListener);
        this.removeAll();
        this.setLayout(new BorderLayout());
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.add((Component)this.barcodePanel, "North");
        JPanel comboPanel = new JPanel((LayoutManager)new GraphPaperLayout(22, 1));
        comboPanel.add((Component)this.areaCombo, new Rectangle(0, 0, 8, 1));
        comboPanel.add((Component)this.supplierCombo, new Rectangle(9, 0, 12, 1));
        northPanel.add((Component)comboPanel, "Center");
        this.add("North", northPanel);
        this.add("Center", (Component)this.scrollPane);
        this.barcodeField.requestFocus();
        StockObjectRegister register = StockObjectRegisterVendor.getStockObjectRegister();
        this.areaCombo.setModel(new DefaultComboBoxModel<Object>(register.getStockAreas().toArray()));
        this.supplierCombo.setModel(new DefaultComboBoxModel<Object>(register.getSuppliers().toArray()));
        this.revalidate();
    }

    public void cancelInvoice() {
        StockObjectRegisterVendor.getStockObjectRegister().removeInvoice(this.model.getInvoice());
    }

    public boolean saveInvoice() {
        StockAreaI area = (StockAreaI)this.areaCombo.getSelectedItem();
        StockSupplierI supplier = (StockSupplierI)this.supplierCombo.getSelectedItem();
        return StockObjectRegisterVendor.getStockObjectRegister().saveInvoice(this.model.getInvoice(), area, supplier);
    }

    public void cleanup() {
        this.removeAll();
        this.scrollPane = new CustomScrollPane();
    }

    public void resetBarcodeField() {
        this.barcodeField.setText("");
        this.barcodeField.requestFocus();
    }

    public void focusBarcodeField() {
        this.barcodeField.requestFocus();
    }

    public void scanPerformed(String barcode) {
        if (barcode == null || barcode.trim().length() == 0) {
            this.resetBarcodeField();
            return;
        }
        barcode = barcode.trim();
        StockInvoiceEntryI scanned = null;
        List matchingItems = StockObjectRegisterVendor.getStockObjectRegister().getStockItemsForBarcode(barcode);
        if (matchingItems.size() > 0) {
            Iterator iterator = this.model.getEntries().iterator();
            while (scanned != null && iterator.hasNext()) {
                StockInvoiceEntryI entry = (StockInvoiceEntryI)iterator.next();
                if (!matchingItems.contains(entry.getStockItem())) continue;
                scanned = entry;
            }
        }
        if (scanned != null) {
            int page = this.model.getPageNum(scanned);
            this.scrollPane.displayPage(page);
            int index = this.model.getEntries().indexOf(scanned);
            InvoiceEntryPanel scannedPanel = (InvoiceEntryPanel)this.model.getComponent(index);
            scannedPanel.setSelected(true);
            scannedPanel.editAmount();
        } else {
            boolean exists = false;
            if (!matchingItems.isEmpty()) {
                StockItemI itemForBarcode = (StockItemI)matchingItems.get(0);
                exists = true;
                this.addNewEntry(itemForBarcode, barcode);
            }
            if (!exists) {
                this.addNewBarcode(barcode);
            }
        }
        this.resetBarcodeField();
    }

    private void addNewBarcode(String barcodeValue) {
        StockItemI item = (StockItemI)Dialogs.displaySelectionDialog((String)"Unknown Barcode", (String)"The barcode scanned is not listed. Select the item to which it corresponds.", (Object[])StockObjectRegisterVendor.getStockObjectRegister().getAllStockItems());
        if (item != null) {
            StockObjectRegisterVendor.getStockObjectRegister().addBarcode(barcodeValue, item);
            this.scanPerformed(barcodeValue);
        }
    }

    public void barcodeValueChanged() {
        String barcode = this.barcodeField.getText();
        this.barcodeField.setText("");
        if (barcode != null && barcode.length() > 0) {
            this.scanPerformed(barcode);
        }
    }

    public void addNewEntry(StockItemI item, String barcode) {
        double qty = Dialogs.getStockItemDouble((StockItemI)item, (String)"Amount: ", (double)1.0);
        if (qty != Double.MIN_VALUE) {
            StockItemI theItem = Dialogs.getStockItemJustSelected();
            StockInvoiceEntryI entry = StockObjectRegisterVendor.getStockObjectRegister().createInvoiceEntry(qty, theItem);
            this.model.addEntry(entry);
            if (!barcode.equals("")) {
                StockObjectRegisterVendor.getStockObjectRegister().addBarcode(barcode, entry.getStockItem());
            }
        }
        this.updateList();
    }

    private void updateList() {
        this.scrollPane.setModel((CustomScrollPaneModel)this.model);
        this.validate();
        this.repaint();
    }

    public void gotEntryDeleted() {
        this.updateList();
    }

    public void gotBarcode(String barcode) {
        if (this.barcodeField.hasFocus()) {
            this.barcodeField.setText(barcode);
            this.barcodeValueChanged();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.barcodeField) {
            this.barcodeValueChanged();
        } else if (event.getSource() == this.addButton) {
            this.addNewEntry(null, "");
        }
    }
}

