/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.receive;

import javax.swing.JMenuBar;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import pocketmate.gui.dialogs.Dialogs;
import pocketmate.gui.navbar.NavBar;
import stockmate.application.ApplicationContext;
import stockmate.application.DisplayController;
import stockmate.gui.display.states.stock.receive.InvoicePanel;

public class ReceiveStock {
    public final Signal complete = Signals.createSignal();
    private NavBar navBar;
    private InvoicePanel invoicePanel = new InvoicePanel();

    public ReceiveStock() {
        this.navBar = new NavBar();
        this.navBar.ok.connect((Object)this, "gotOk");
        this.navBar.cancel.connect((Object)this, "gotCancel");
    }

    public void start() {
        DisplayController dc = ApplicationContext.getDisplayController();
        dc.displayWaitIcon();
        this.invoicePanel.newInvoice();
        this.invoicePanel.display();
        dc.setDisplay(this.invoicePanel, (JMenuBar)this.navBar);
        dc.removeWaitIcon();
        this.invoicePanel.focusBarcodeField();
    }

    public void gotOk() {
        if (this.invoicePanel.saveInvoice()) {
            this.invoicePanel.cleanup();
            Dialogs.displayInfoDialog(null, (String)"Delivery Note created.");
            this.complete.emit();
        } else {
            Dialogs.displayWarningDialog((String)"Cannot Create Delivery Note", (String)"Cannot connect with Server to create the delivery note.\nPlease move to a connected area and try again.");
        }
    }

    public void gotCancel() {
        boolean choice = Dialogs.displayChoiceDialog((String)"Cancel Invoice?", (String)"Are you sure you wish to cancel this invoice?", (String)"Yes", (String)"No");
        if (choice) {
            this.invoicePanel.cancelInvoice();
            this.complete.emit();
        }
    }
}

