/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.stocktake;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.util.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import pocketmate.gui.dialogs.Dialogs;
import stockmate.asyncstock.SimpleQuantity;
import stockmate.database.interfaces.stock.MeasureUnitI;
import stockmate.database.interfaces.stock.QuantityI;
import stockmate.database.interfaces.stock.StockObjectRegisterVendor;
import stockmate.database.interfaces.stock.StockTakeEntryI;

class StockTakeEntryPanel
extends JPanel
implements ActionListener {
    private static final Insets insets = new Insets(1, 1, 1, 1);
    private static final Color selected = new Color(20, 210, 210);
    private static final Color completed = new Color(150, 150, 150);
    private StockTakeEntryI entry = null;
    private boolean isSelected = false;
    private static StockTakeEntryPanel selectedPanel;
    public static final Signal reset;
    private JLabel nameLabel = new JLabel();
    private JLabel amountLabel;
    private JButton addAmountButton;
    private JButton setAmountButton;

    public StockTakeEntryPanel() {
        this.nameLabel.setName("nameLabel");
        this.amountLabel = new JLabel();
        this.amountLabel.setName("amountLabel");
        this.setAmountButton = new JButton(IconLoader.get((String)"/pocketmate/images/pmh_calc.png"));
        this.setAmountButton.setName("setAmountBut");
        this.setAmountButton.setMargin(insets);
        this.setAmountButton.setOpaque(false);
        this.setAmountButton.setBorderPainted(false);
        this.setAmountButton.addActionListener(this);
        this.addAmountButton = new JButton(IconLoader.get((String)"/pocketmate/images/pmh_calc_plus.png"));
        this.addAmountButton.setName("addAmountBut");
        this.addAmountButton.setMargin(insets);
        this.addAmountButton.setOpaque(false);
        this.addAmountButton.setBorderPainted(false);
        this.addAmountButton.addActionListener(this);
        this.setLayout((LayoutManager)new GraphPaperLayout(new Dimension(10, 5)));
        this.add((Component)this.nameLabel, new Rectangle(0, 1, 6, 3));
        this.add((Component)this.amountLabel, new Rectangle(6, 1, 2, 3));
        this.add((Component)this.setAmountButton, new Rectangle(8, 1, 1, 3));
        this.add((Component)this.addAmountButton, new Rectangle(9, 1, 1, 3));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                StockTakeEntryPanel.this.setSelected(true);
            }
        });
        if (selectedPanel == null) {
            this.setSelected(true);
        }
    }

    public StockTakeEntryI getEntry() {
        return this.entry;
    }

    public void setEntry(StockTakeEntryI newEntry) {
        this.entry = newEntry;
        this.nameLabel.setText(newEntry.getStockItem().getLabel());
        QuantityI amount = newEntry.getActualQuantity();
        if (amount == null) {
            this.amountLabel.setText("");
        } else {
            this.updateAmountLabel();
        }
    }

    public Color getBackground() {
        if (this.isSelected) {
            return selected;
        }
        if (this.entry != null && StockObjectRegisterVendor.getStockObjectRegister().isChecked(this.entry)) {
            return completed;
        }
        return super.getBackground();
    }

    public void setSelected(boolean newSelected) {
        if (newSelected) {
            if (selectedPanel != null) {
                selectedPanel.setSelected(false);
            }
            selectedPanel = this;
            this.isSelected = true;
        } else {
            selectedPanel = null;
            this.isSelected = false;
        }
        this.repaint();
    }

    public void setChecked(boolean checked) {
        StockObjectRegisterVendor.getStockObjectRegister().setChecked(this.entry, checked);
    }

    public void editAmount() {
        this.addAmountButton.doClick();
    }

    public static StockTakeEntryPanel getSelectedPanel() {
        return selectedPanel;
    }

    public static void setSelectedPanel(StockTakeEntryPanel panel) {
        if (selectedPanel != null) {
            selectedPanel.setSelected(false);
        }
        selectedPanel = panel;
    }

    private void changeAmount(boolean update) {
        QuantityI amount;
        QuantityI actualQty = this.entry.getActualQuantity();
        if (actualQty == null) {
            actualQty = StockObjectRegisterVendor.getStockObjectRegister().createQuantity(0.0);
        }
        QuantityI defaultAmount = StockObjectRegisterVendor.getStockObjectRegister().createQuantity(0.0);
        if (!update) {
            defaultAmount = actualQty;
        }
        if ((amount = Dialogs.getStockDouble((String)this.entry.getStockItem().getLabel(), (String)"Amount:", (QuantityI)defaultAmount)) != null) {
            QuantityI initialQty = SimpleQuantity.ZERO_QUANTITY;
            if (update) {
                initialQty = actualQty;
            }
            QuantityI actual = initialQty.add(amount);
            StockObjectRegisterVendor.getStockObjectRegister().setStockTakeEntryParameters(this.entry, actual);
            this.setChecked(true);
            this.setSelected(true);
            this.updateAmountLabel();
        }
        reset.emit();
    }

    private void updateAmountLabel() {
        QuantityI amount = this.entry.getActualQuantity();
        MeasureUnitI unit = this.entry.getStockItem().getDisplayMeasureUnit();
        StringBuffer SB = new StringBuffer();
        SB.append(amount.getAmountString());
        SB.append(" ");
        SB.append(unit.getSuffix());
        this.amountLabel.setText(SB.toString());
    }

    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.setAmountButton) {
            this.changeAmount(false);
        } else if (source == this.addAmountButton) {
            this.changeAmount(true);
        }
    }

    static {
        reset = Signals.createSignal();
    }
}

