/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.stocktake;

import au.com.ordermate.util.IconLoader;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import pocketmate.gui.dialogs.Dialogs;
import pocketmate.gui.navbar.NavBar;
import stockmate.application.ApplicationContext;
import stockmate.application.DisplayController;
import stockmate.database.interfaces.stock.StockAreaI;
import stockmate.database.interfaces.stock.StockGroupI;
import stockmate.database.interfaces.stock.StockObjectRegisterVendor;
import stockmate.database.interfaces.stock.StockTakeI;
import stockmate.device.scanner.NoScannerException;
import stockmate.device.scanner.Scanner;
import stockmate.gui.display.MessagePanel;
import stockmate.gui.display.states.stock.stocktake.StocktakePanel;

public class Stocktake
implements ActionListener {
    private static final Insets margin = new Insets(0, 0, 0, 0);
    private List entries;
    private StockAreaI stockArea;
    private StockGroupI stockGroup;
    private StockTakeI stockTake;
    private StocktakePanel gui;
    private NavBar navBar;
    private MessagePanel messagePanel;
    private Component glassPane;
    private JButton quickSaveButton;
    public final Signal complete = Signals.createSignal();
    public final Signal stockTakingDone = Signals.createSignal();

    public Stocktake() {
        this.messagePanel = new MessagePanel();
        this.navBar = new NavBar();
        this.navBar.setCancelButtonVisible(false);
        this.gui = new StocktakePanel();
        this.quickSaveButton = new JButton(IconLoader.get((String)"/pocketmate/images/pmh_upload.png"));
        this.quickSaveButton.setMargin(margin);
        this.quickSaveButton.setBorderPainted(false);
        this.quickSaveButton.addActionListener(this);
        this.navBar.setComponent((JComponent)this.quickSaveButton, "");
        this.navBar.ok.connect((Object)this, "gotOk");
    }

    private void setupGui() {
        this.gui.display(this.entries);
        DisplayController dc = ApplicationContext.getDisplayController();
        dc.displayWaitIcon();
        dc.setDisplay(this.gui, (JMenuBar)this.navBar);
        dc.removeWaitIcon();
        this.gui.focusBarcodeField();
    }

    private void loadStocktake() {
        this.messagePanel.setText("Downloading from server...");
        DisplayController dc = ApplicationContext.getDisplayController();
        this.glassPane = dc.getGlassPane();
        dc.setGlassPane(this.messagePanel);
        this.messagePanel.setVisible(true);
        if (this.stockTake != null && this.stockArea != null && this.stockGroup != null) {
            this.entries = StockObjectRegisterVendor.getStockObjectRegister().getStockTakeEntries(this.stockTake, this.stockArea, this.stockGroup);
        }
        if (this.entries.size() == 0) {
            dc.setGlassPane(this.glassPane);
            this.glassPane.setVisible(false);
            Dialogs.displayCriticalDialog(null, (String)("There are no " + this.stockGroup.getName() + " items to stocktake in the " + this.stockArea.getLabel() + " area."));
            this.finishedWithStockTake();
            return;
        }
        this.setupGui();
        dc.setGlassPane(this.glassPane);
        this.glassPane.setVisible(false);
    }

    private boolean saveStocktake() {
        boolean saved = false;
        ApplicationContext.getDisplayController().displayWaitIcon();
        saved = StockObjectRegisterVendor.getStockObjectRegister().saveStockTake(this.stockTake);
        ApplicationContext.getDisplayController().removeWaitIcon();
        return saved;
    }

    public void start() {
        this.startImpl(this.stockTake == null, true, this.stockGroup == null, true);
    }

    private boolean startImpl(boolean selectStockTake, boolean doSelectStockArea, boolean doSelectStockGroup, boolean refreshGroups) {
        List groups;
        List areas;
        if (selectStockTake) {
            this.stockTake = Dialogs.getStockTake((boolean)true);
            if (this.stockTake == null) {
                this.finishedWithStockTake();
                return false;
            }
        }
        if ((areas = StockObjectRegisterVendor.getStockObjectRegister().getStockAreas()).size() > 0) {
            this.stockArea = Dialogs.getStockArea((boolean)true);
            if (this.stockArea == null) {
                this.finishedWithStockTake();
                return false;
            }
        }
        if ((groups = StockObjectRegisterVendor.getStockObjectRegister().getTopLevelStockGroups()).size() > 0) {
            this.stockGroup = Dialogs.getStockGroup((boolean)refreshGroups);
            if (this.stockGroup == null) {
                this.finishedWithStockTake();
                return false;
            }
        }
        this.loadStocktake();
        try {
            Scanner.setScannerListener(this.gui);
        }
        catch (NoScannerException e) {
            // empty catch block
        }
        return true;
    }

    private void finishedWithStockTake() {
        this.stockTake = null;
        this.complete.emit();
    }

    public void gotOk() {
        try {
            Scanner.cancelScannerListener();
        }
        catch (NoScannerException noScannerException) {
            // empty catch block
        }
        this.stockTakingDone.emit();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.quickSaveButton && !this.saveStocktake()) {
            Dialogs.displayWarningDialog((String)"Couldn't synchronise", (String)"There was a communication error when synchronising data with the Server.\nPlease ensure you are within a connected area.");
        }
    }
}

