/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.stocktake;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import ordermate.gui.scroll.AbstractScrollPaneModel;
import stockmate.database.interfaces.stock.StockTakeEntryI;
import stockmate.gui.display.states.stock.stocktake.StockTakeEntryPanel;

public class StocktakeModel
extends AbstractScrollPaneModel {
    public static final int NUM_ROWS = 7;
    private List entries = new ArrayList();
    private StockTakeEntryPanel[] panels = new StockTakeEntryPanel[7];

    public StocktakeModel() {
        super(1, 7);
        for (int i = 0; i < this.panels.length; ++i) {
            this.panels[i] = new StockTakeEntryPanel();
        }
    }

    public void clear() {
        this.entries = new ArrayList();
        StockTakeEntryPanel.setSelectedPanel(this.panels[0]);
    }

    public List getEntries() {
        return this.entries;
    }

    public void setEntries(List newEntries) {
        if (newEntries == null) {
            throw new IllegalArgumentException("entries cannot be null!");
        }
        this.entries = newEntries;
    }

    public int getPageNum(StockTakeEntryI entry) {
        if (entry == null) {
            throw new IllegalArgumentException("entry cannot be null.");
        }
        int index = this.entries.indexOf(entry);
        if (index == -1) {
            return -1;
        }
        return index / 7;
    }

    public int getSize() {
        return this.entries.size();
    }

    protected Component getComponent(int index) {
        if (index < 0 || index >= this.getSize()) {
            String s = index + " is < 0 or >= " + this.getSize();
            throw new ArrayIndexOutOfBoundsException(s);
        }
        StockTakeEntryI entry = (StockTakeEntryI)this.entries.get(index);
        int numPages = index / 7;
        int i = index - numPages * 7;
        this.panels[i].setEntry(entry);
        return this.panels[i];
    }

    public void setItems(List items) {
        this.setEntries(items);
    }

    public void setColumns(int columns) {
    }

    public void setRowsPerPage(int rows) {
    }
}

