/*
 * Decompiled with CFR 0.152.
 */
package stockmate.gui.display.states.stock.stocktake;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import ordermate.OrderMate;
import ordermate.gui.InputAdapterFactory;
import ordermate.gui.scroll.CustomScrollPane;
import ordermate.gui.scroll.CustomScrollPaneModel;
import ordermate.gui.scroll.PageChangeEvent;
import ordermate.gui.scroll.PageChangeListener;
import pocketmate.gui.dialogs.Dialogs;
import stockmate.database.interfaces.stock.StockObjectRegisterVendor;
import stockmate.database.interfaces.stock.StockTakeEntryI;
import stockmate.device.scanner.ScannerListener;
import stockmate.gui.display.states.stock.BarcodeDocument;
import stockmate.gui.display.states.stock.stocktake.StockTakeEntryPanel;
import stockmate.gui.display.states.stock.stocktake.StocktakeModel;

class StocktakePanel
extends JPanel
implements ScannerListener,
ActionListener {
    private CustomScrollPane scrollPane;
    private StocktakeModel model = new StocktakeModel();
    private JTextField barcodeField;
    private JPanel barcodePanel;

    public StocktakePanel() {
        BarcodeDocument doc = new BarcodeDocument();
        doc.barcodeInput.connect((Object)this, "barcodeValueChanged");
        this.barcodeField = new JTextField(doc, "", 10);
        this.barcodeField.addActionListener(this);
        this.barcodePanel = new JPanel();
        this.barcodePanel.setLayout(new FlowLayout(0));
        this.barcodePanel.add(new JLabel("Barcode:"));
        this.barcodePanel.add(this.barcodeField);
        StockTakeEntryPanel.reset.connect((Object)this, "resetBarcodeField");
        try {
            InputAdapterFactory.getAdapter().barcodeInput.connect((Object)this, "gotBarcode");
        }
        catch (IllegalStateException ex) {
            OrderMate.LOG.info((Object)"No InputAdapter defined, not listening on barcodes.");
        }
    }

    public void display(List entries) {
        if (entries == null) {
            throw new IllegalArgumentException("entries cannot be null!");
        }
        this.barcodeField.setText("");
        this.model.setEntries(entries);
        this.scrollPane = new CustomScrollPane((CustomScrollPaneModel)this.model);
        this.scrollPane.addPageChangeListener(new PageChangeListener(){

            public void pageChanged(PageChangeEvent e) {
                StocktakePanel.this.barcodeField.requestFocus();
            }
        });
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add("North", this.barcodePanel);
        this.add("Center", (Component)this.scrollPane);
        this.revalidate();
        this.barcodeField.requestFocus();
    }

    public void cleanup() {
        this.removeAll();
        this.scrollPane = new CustomScrollPane();
        this.model.clear();
    }

    public void resetBarcodeField() {
        this.barcodeField.setText("");
        this.barcodeField.requestFocus();
    }

    public void focusBarcodeField() {
        this.barcodeField.requestFocus();
    }

    public void scanPerformed(String barcode) {
        ArrayList<StockTakeEntryI> matchingItems = new ArrayList<StockTakeEntryI>();
        StockTakeEntryI scanned = null;
        List possibleItems = StockObjectRegisterVendor.getStockObjectRegister().getStockItemsForBarcode(barcode);
        Iterator entries = this.model.getEntries().iterator();
        while (entries.hasNext()) {
            StockTakeEntryI entry = (StockTakeEntryI)entries.next();
            if (!possibleItems.contains(entry.getStockItem())) continue;
            matchingItems.add(entry);
        }
        if (matchingItems.size() == 0) {
            StockTakeEntryPanel entryPanel = StockTakeEntryPanel.getSelectedPanel();
            if (entryPanel == null || entryPanel.getEntry() == null) {
                return;
            }
            String message = "No matching item found. Do you want to assign this barcode to " + entryPanel.getEntry().getStockItem().getLabel() + "?";
            if (Dialogs.displayChoiceDialog((String)message, (String)"Yes", (String)"No")) {
                StockObjectRegisterVendor.getStockObjectRegister().addBarcode(barcode, entryPanel.getEntry().getStockItem());
                scanned = entryPanel.getEntry();
            }
        } else {
            scanned = matchingItems.size() == 1 ? (StockTakeEntryI)matchingItems.get(0) : Dialogs.getStockEntry(matchingItems);
        }
        if (scanned != null) {
            int page = this.model.getPageNum(scanned);
            this.scrollPane.displayPage(page);
            int index = this.model.getEntries().indexOf(scanned);
            StockTakeEntryPanel scannedPanel = (StockTakeEntryPanel)this.model.getComponent(index);
            scannedPanel.setSelected(true);
            scannedPanel.editAmount();
        }
        this.resetBarcodeField();
    }

    public void barcodeValueChanged() {
        String barcode = this.barcodeField.getText();
        if (barcode != null && barcode.length() > 0) {
            this.scanPerformed(barcode);
        }
    }

    public void gotBarcode(String entry) {
        if (this.barcodeField.hasFocus()) {
            this.barcodeField.setText(entry);
            this.barcodeValueChanged();
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.barcodeField) {
            String barcode = this.barcodeField.getText();
            barcode = barcode + '/';
            this.barcodeField.setText(barcode);
            this.barcodeValueChanged();
        }
    }
}

