/*
 * Decompiled with CFR 0.152.
 */
package stockmate.http;

import au.com.ordermate.OrderMateLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

public class HttpDownloader {
    private String address;
    private HttpURLConnection activeConnection;

    public HttpDownloader(String servletAddress) {
        this.address = servletAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validateGet() {
        int returnCode;
        this.cleanUp();
        HttpURLConnection con = null;
        try {
            con = this.openConnection();
            con.setRequestMethod("GET");
            returnCode = con.getResponseCode();
        }
        catch (IOException ex) {
            returnCode = 503;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream openConnectionAndGetStream() {
        HttpURLConnection con = null;
        InputStream input = null;
        try {
            con = this.openConnection();
            this.requestInformation(con);
            if (con.getResponseCode() == 200) {
                this.activeConnection = con;
                input = con.getInputStream();
            } else {
                OrderMateLog.LOG.warn((Object)("Http Connection refused:" + con.getResponseMessage()));
            }
        }
        catch (ProtocolException ex) {
            OrderMateLog.LOG.warn((Object)"Invalid Http Protocol used.", (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            OrderMateLog.LOG.warn((Object)"Couldn't establish a connection with Server.", (Throwable)ex);
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn((Object)"Error reading/writing Server.", (Throwable)ex);
        }
        finally {
            if (input == null && con != null) {
                con.disconnect();
            }
        }
        return input;
    }

    public void cleanUp() {
        if (this.activeConnection != null) {
            this.activeConnection.disconnect();
            this.activeConnection = null;
        }
    }

    private HttpURLConnection openConnection() throws MalformedURLException, IOException {
        OrderMateLog.LOG.info((Object)("Establishing a GET connection to:" + this.address));
        URL url = new URL(this.address);
        return (HttpURLConnection)url.openConnection();
    }

    private void requestInformation(HttpURLConnection con) throws ProtocolException {
        con.setRequestMethod("GET");
    }
}

