/*
 * Decompiled with CFR 0.152.
 */
package stockmate.http;

import au.com.ordermate.OrderMateLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import ordermate.OrderMate;

public class HttpUploader {
    private String address;
    private HttpURLConnection activeConnection;

    public HttpUploader(String servletAddress) {
        this.address = servletAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int validatePost() {
        int returnCode;
        HttpURLConnection con = null;
        try {
            con = this.openConnection();
            con.setRequestMethod("POST");
            returnCode = con.getResponseCode();
        }
        catch (IOException ex) {
            OrderMate.LOG.error((Object)"Couldn't get a reposnse to my Post request:", (Throwable)ex);
            returnCode = 503;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        return returnCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getStreamForSerializing() {
        if (this.activeConnection != null) {
            throw new IllegalStateException("Call cleanUp() before making a new connection.");
        }
        OutputStream output = null;
        try {
            this.activeConnection = this.openConnection();
            this.setupConnection(this.activeConnection);
            output = this.activeConnection.getOutputStream();
        }
        catch (ProtocolException ex) {
            OrderMateLog.LOG.warn((Object)"Invalid Http Protocol used.", (Throwable)ex);
        }
        catch (MalformedURLException ex) {
            OrderMateLog.LOG.warn((Object)"Couldn't establish a connection with Server.", (Throwable)ex);
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn((Object)"Error reading/writing Server.", (Throwable)ex);
        }
        finally {
            if (output == null && this.activeConnection != null) {
                this.activeConnection.disconnect();
            }
        }
        return output;
    }

    public void cleanUp() {
        if (this.activeConnection != null) {
            this.activeConnection.disconnect();
            this.activeConnection = null;
        }
    }

    private HttpURLConnection openConnection() throws MalformedURLException, IOException {
        OrderMateLog.LOG.info((Object)("Establishing a POST connection to:" + this.address));
        URL url = new URL(this.address);
        return (HttpURLConnection)url.openConnection();
    }

    private void setupConnection(HttpURLConnection con) throws ProtocolException {
        con.setRequestMethod("POST");
        con.setDoOutput(true);
    }

    public boolean postDataAccepted() throws IOException {
        if (this.activeConnection != null) {
            return this.activeConnection.getResponseCode() == 200;
        }
        return false;
    }

    public InputStream getActiveInputStream() throws IOException {
        if (this.activeConnection != null) {
            return this.activeConnection.getInputStream();
        }
        throw new IllegalStateException("Must have a connection before requesting a response");
    }
}

