/*
 * Decompiled with CFR 0.152.
 */
package stockmate.login;

import au.com.ordermate.OrderMateLog;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParserException;
import pocketmate.Configuration;
import stockmate.application.LoginManager;
import stockmate.database.interfaces.UserI;
import stockmate.http.HttpDownloader;
import stockmate.login.SimpleUser;
import stockmate.login.SimpleUserVisitor;
import stockmate.xml.XMLObjectHelper;

public class StockItLoginManager
implements LoginManager {
    private List usersList = new ArrayList();
    private UserI currentUser;
    private SimpleUserVisitor visitor = new SimpleUserVisitor(this);

    public boolean loginAsUser(String user, String password) {
        SimpleUser foundUser = this.getUserByName(user);
        if (foundUser != null && password != null && password.trim().length() > 0 && foundUser.pinCorrect(password)) {
            this.currentUser = foundUser;
            return true;
        }
        return false;
    }

    public void logoutCurrentUser() {
        this.currentUser = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchroniseUserData() {
        this.usersList.clear();
        HttpDownloader downloader = Configuration.current.createDownloader("user");
        try {
            InputStream input = downloader.openConnectionAndGetStream();
            if (input != null) {
                KXmlParser docParser = XMLObjectHelper.openDocumentForParsing(input);
                this.visitor.parseFromXML(docParser);
            } else {
                OrderMateLog.LOG.warn((Object)"Connection refused or lost when downloading user information");
            }
        }
        catch (IOException ex) {
            OrderMateLog.LOG.warn((Object)"Problem downloading user information, connection.", (Throwable)ex);
        }
        catch (XmlPullParserException ex) {
            OrderMateLog.LOG.warn((Object)"Problem downloading user information, XML Format.", (Throwable)ex);
        }
        catch (Exception ex) {
            OrderMateLog.LOG.warn((Object)"Unresolved error while downloading user information.", (Throwable)ex);
        }
        finally {
            downloader.cleanUp();
        }
    }

    private SimpleUser getUserByName(String name) {
        Iterator it = this.usersList.iterator();
        while (it.hasNext()) {
            SimpleUser nextUser = (SimpleUser)it.next();
            if (!nextUser.getName().equals(name)) continue;
            return nextUser;
        }
        return null;
    }

    public String[] getUsernames() {
        String[] names = new String[this.usersList.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = ((UserI)this.usersList.get(i)).getName();
        }
        return names;
    }

    public boolean canLogin() {
        return this.usersList.size() > 0;
    }

    public String getCurrentUsername() {
        if (this.currentUser != null) {
            return this.currentUser.getName();
        }
        return null;
    }

    void addUser(SimpleUser user) {
        if (user != null && !this.usersList.contains(user)) {
            this.usersList.add(user);
        }
    }
}

