/*
 * Decompiled with CFR 0.152.
 */
package stockmate.xml.serializers.stock;

import java.io.IOException;
import java.util.Iterator;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockGroupI;
import stockmate.xml.XMLObjectSerializer;
import stockmate.xml.serializers.stock.StockItemSerializer;

public class StockGroupSerializer
implements XMLObjectSerializer {
    public static final String LABEL = "label";
    public static final String TAG = "group";
    private StockItemSerializer itemVisitor = this.createItemSerializer();

    protected StockItemSerializer createItemSerializer() {
        return new StockItemSerializer();
    }

    private void serializeGroup(StockGroupI group, KXmlSerializer docSerializer) throws XmlPullParserException, IOException {
        Iterator it;
        docSerializer.startTag(null, TAG);
        docSerializer.attribute(null, "id", group.intID() + "");
        docSerializer.attribute(null, LABEL, group.getName());
        if (group.getStockItems().size() > 0) {
            it = group.getStockItems().iterator();
            while (it.hasNext()) {
                this.itemVisitor.serializeToXML(docSerializer, it.next());
            }
        }
        if (group.getSubGroups().size() > 0) {
            it = group.getSubGroups().iterator();
            while (it.hasNext()) {
                this.serializeGroup((StockGroupI)it.next(), docSerializer);
            }
        }
        docSerializer.endTag(null, TAG);
    }

    public void serializeToXML(KXmlSerializer serializer, Object toSerialize) throws IOException, XmlPullParserException {
        this.serializeGroup((StockGroupI)toSerialize, serializer);
    }
}

