/*
 * Decompiled with CFR 0.152.
 */
package stockmate.xml.serializers.stock;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockInvoiceEntryI;
import stockmate.xml.XMLObjectSerializer;

public class StockInvoiceEntrySerializer
implements XMLObjectSerializer {
    public static final String TAG_NAME = "entry";
    public static final String ITEM = "item";
    public static final String NUM_RECEIVED = "num_received";
    private NumberFormat qtyFormat;

    public StockInvoiceEntrySerializer() {
        this(null);
    }

    public StockInvoiceEntrySerializer(NumberFormat quantityFormat) {
        this.qtyFormat = quantityFormat;
        if (this.qtyFormat == null) {
            this.qtyFormat = new DecimalFormat("#0.0####");
        }
    }

    public void serializeToXML(KXmlSerializer docSerializer, Object toSerialize) throws IOException, XmlPullParserException {
        StockInvoiceEntryI entry = (StockInvoiceEntryI)toSerialize;
        docSerializer.startTag(null, TAG_NAME);
        docSerializer.attribute(null, "id", entry.intID() + "");
        docSerializer.attribute(null, ITEM, entry.getStockItem().intID() + "");
        docSerializer.attribute(null, NUM_RECEIVED, this.qtyFormat.format(entry.getNumReceived()));
        docSerializer.endTag(null, TAG_NAME);
    }
}

