/*
 * Decompiled with CFR 0.152.
 */
package stockmate.xml.serializers.stock;

import java.io.IOException;
import java.util.Iterator;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockInvoiceI;
import stockmate.xml.XMLObjectSerializer;
import stockmate.xml.serializers.stock.StockInvoiceEntrySerializer;

public class StockInvoiceSerializer
implements XMLObjectSerializer {
    public static final String TYPE = "type";
    public static final String NUMBER = "number";
    public static final String AREA = "area";
    public static final String SUPPLIER = "supplier";
    public static final String TAG_NAME = "invoice";
    private StockInvoiceEntrySerializer entrySerializer = new StockInvoiceEntrySerializer();

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        docSerializer.startTag(null, TAG_NAME);
        StockInvoiceI invoice = (StockInvoiceI)objectToSerialise;
        docSerializer.attribute(null, "id", invoice.intID() + "");
        docSerializer.attribute(null, TYPE, invoice.getInvoiceType() + "");
        docSerializer.attribute(null, NUMBER, invoice.getInvoiceNumber() + "");
        docSerializer.attribute(null, AREA, invoice.getStockArea().intID() + "");
        docSerializer.attribute(null, SUPPLIER, invoice.getSupplier().intID() + "");
        Iterator it = ((StockInvoiceI)objectToSerialise).getEntries().iterator();
        while (it.hasNext()) {
            this.entrySerializer.serializeToXML(docSerializer, it.next());
        }
        docSerializer.endTag(null, TAG_NAME);
    }
}

