/*
 * Decompiled with CFR 0.152.
 */
package stockmate.xml.serializers.stock;

import java.io.IOException;
import java.util.Iterator;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockItemI;
import stockmate.xml.XMLObjectSerializer;
import stockmate.xml.serializers.stock.StockBarcodeSerializer;

public class StockItemSerializer
implements XMLObjectSerializer {
    public static final String LABEL = "label";
    public static final String DISPLAY_UNIT = "display_unit";
    public static final String TAG_NAME = "item";
    private StockBarcodeSerializer barcodeSerializer = new StockBarcodeSerializer();

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        docSerializer.startTag(null, TAG_NAME);
        StockItemI item = (StockItemI)objectToSerialise;
        docSerializer.attribute(null, "id", item.intID() + "");
        docSerializer.attribute(null, LABEL, item.getLabel());
        if (item.getDisplayMeasureUnit() != null) {
            docSerializer.attribute(null, DISPLAY_UNIT, this.getDisplayMeasureUnitName(item));
        }
        Iterator it = item.getStockBarcodes().iterator();
        while (it.hasNext()) {
            this.barcodeSerializer.serializeToXML(docSerializer, it.next());
        }
        docSerializer.endTag(null, TAG_NAME);
    }

    protected String getDisplayMeasureUnitName(StockItemI item) {
        return item.getDisplayMeasureUnit().getName();
    }
}

