/*
 * Decompiled with CFR 0.152.
 */
package stockmate.xml.serializers.stock;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockObjectRegister;
import stockmate.xml.XMLObjectSerializer;
import stockmate.xml.serializers.stock.BarcodePrefixSerializer;
import stockmate.xml.serializers.stock.StockAreaSerializer;
import stockmate.xml.serializers.stock.StockGroupSerializer;
import stockmate.xml.serializers.stock.StockInvoiceSerializer;
import stockmate.xml.serializers.stock.StockSupplierSerializer;
import stockmate.xml.serializers.stock.StockTakeSerializer;

public class StockRegisterSerializer
implements XMLObjectSerializer {
    private static final String ROOT = "stock_data";
    public static final String AREA = "area";
    public static final String SUPPLIER = "supplier";
    public static final String GROUP = "group";
    public static final String INVOICE = "invoice";
    public static final String STOCKTAKE = "take";
    public static final String BARCODE_PREFIX = "bc_pref";
    private Map serializerMap = new HashMap();

    public StockRegisterSerializer() {
        this.setSerializer(AREA, new StockAreaSerializer());
        this.setSerializer(SUPPLIER, new StockSupplierSerializer());
        this.setSerializer(GROUP, new StockGroupSerializer());
        this.setSerializer(STOCKTAKE, new StockTakeSerializer());
        this.setSerializer(INVOICE, new StockInvoiceSerializer());
        this.setSerializer(BARCODE_PREFIX, new BarcodePrefixSerializer());
    }

    public void setSerializer(String tagName, XMLObjectSerializer serializer) {
        this.serializerMap.put(tagName, serializer);
    }

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        if (objectToSerialise == null || !(objectToSerialise instanceof StockObjectRegister)) {
            throw new IllegalArgumentException("Node passed must be a StockObjectRegister.");
        }
        StockObjectRegister register = (StockObjectRegister)objectToSerialise;
        docSerializer.startTag(null, ROOT);
        this.serializeData(register, docSerializer);
        docSerializer.endTag(null, ROOT);
    }

    protected void serializeData(StockObjectRegister register, KXmlSerializer docSerializer) throws IOException, XmlPullParserException {
        this.serializeList(AREA, register.getStockAreas(), docSerializer);
        this.serializeList(SUPPLIER, register.getSuppliers(), docSerializer);
        this.serializeList(GROUP, register.getTopLevelStockGroups(), docSerializer);
        this.serializeList(STOCKTAKE, register.getStockTakes(), docSerializer);
        this.serializeList(INVOICE, register.getInvoices(), docSerializer);
        this.serializeList(BARCODE_PREFIX, register.getBarcodePrefixes(), docSerializer);
    }

    protected void serializeList(String name, List objectList, KXmlSerializer docSerializer) throws XmlPullParserException, IOException {
        XMLObjectSerializer serializer = (XMLObjectSerializer)this.serializerMap.get(name);
        if (serializer != null) {
            Iterator it = objectList.iterator();
            while (it.hasNext()) {
                serializer.serializeToXML(docSerializer, it.next());
            }
        }
    }
}

