/*
 * Decompiled with CFR 0.152.
 */
package stockmate.xml.serializers.stock;

import java.io.IOException;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.asyncstock.SimpleQuantity;
import stockmate.database.interfaces.stock.StockTakeEntryI;
import stockmate.xml.XMLObjectSerializer;

public class StockTakeEntrySerializer
implements XMLObjectSerializer {
    public static final String TAG_NAME = "entry";
    public static final String ITEM = "item";
    public static final String AREA = "area";
    public static final String ACTUAL_QUANTITY = "actual_qty";
    public static final String EXPECTED_QUANTITY = "expected_qty";

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        StockTakeEntryI entry = (StockTakeEntryI)objectToSerialise;
        docSerializer.startTag(null, TAG_NAME);
        docSerializer.attribute(null, "id", entry.intID() + "");
        docSerializer.attribute(null, ITEM, entry.getStockItem().intID() + "");
        docSerializer.attribute(null, AREA, entry.getStockArea().intID() + "");
        if (entry.getActualQuantity() != null) {
            double value = ((SimpleQuantity)entry.getActualQuantity()).doubleValue() * entry.getStockItem().getDisplayMeasureUnit().getValue();
            docSerializer.attribute(null, ACTUAL_QUANTITY, String.valueOf(value));
        }
        docSerializer.attribute(null, EXPECTED_QUANTITY, entry.getExpectedQuantity().getAmountString());
        docSerializer.endTag(null, TAG_NAME);
    }
}

