/*
 * Decompiled with CFR 0.152.
 */
package stockmate.xml.serializers.stock;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.kxml2.io.KXmlSerializer;
import org.xmlpull.v1.XmlPullParserException;
import stockmate.database.interfaces.stock.StockTakeI;
import stockmate.xml.XMLObjectSerializer;
import stockmate.xml.serializers.stock.StockTakeEntrySerializer;

public class StockTakeSerializer
implements XMLObjectSerializer {
    private static final String STOCKTAKE = "stocktake";
    public static final String DATE = "date";
    public static final String LIVENESS = "is_live";
    private StockTakeEntrySerializer entrySerializer;
    private DateFormat dateFormat;

    public StockTakeSerializer() {
        this(null, null);
    }

    public StockTakeSerializer(DateFormat dateFormatToUse) {
        this(dateFormatToUse, null);
    }

    public StockTakeSerializer(DateFormat dateFormatToUse, StockTakeEntrySerializer entrySerializerToUse) {
        this.dateFormat = dateFormatToUse;
        if (dateFormatToUse == null) {
            this.dateFormat = new SimpleDateFormat("dd/MM/yyyy HH:mm");
        }
        this.entrySerializer = entrySerializerToUse;
        if (this.entrySerializer == null) {
            this.entrySerializer = new StockTakeEntrySerializer();
        }
    }

    public void serializeToXML(KXmlSerializer docSerializer, Object objectToSerialise) throws XmlPullParserException, IOException {
        docSerializer.startTag(null, STOCKTAKE);
        StockTakeI take = (StockTakeI)objectToSerialise;
        Date date = take.getDate();
        docSerializer.attribute(null, "id", take.intID() + "");
        docSerializer.attribute(null, DATE, this.dateFormat.format(date));
        docSerializer.attribute(null, LIVENESS, "" + take.isLive());
        Iterator it = this.getEntries((StockTakeI)objectToSerialise).iterator();
        while (it.hasNext()) {
            this.entrySerializer.serializeToXML(docSerializer, it.next());
        }
        docSerializer.endTag(null, STOCKTAKE);
    }

    protected List getEntries(StockTakeI stocktake) {
        return stocktake.getStockTakeEntries();
    }
}

