/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import twitter4j.GeoLocation;
import twitter4j.HttpParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeoQuery
implements Serializable {
    private static final long serialVersionUID = 5434503339001056634L;
    private GeoLocation location;
    private String query = null;
    private String ip = null;
    private String accuracy = null;
    private String granularity = null;
    private int maxResults = -1;

    public GeoQuery(GeoLocation location) {
        this.location = location;
    }

    public GeoQuery(String ip) {
        this.ip = ip;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getIp() {
        return this.ip;
    }

    public String getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(String accuracy) {
        this.accuracy = accuracy;
    }

    public GeoQuery accuracy(String accuracy) {
        this.setAccuracy(accuracy);
        return this;
    }

    public String getGranularity() {
        return this.granularity;
    }

    public void setGranularity(String granularity) {
        this.granularity = granularity;
    }

    public GeoQuery granularity(String granularity) {
        this.setGranularity(granularity);
        return this;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public void setMaxResults(int maxResults) {
        this.maxResults = maxResults;
    }

    public GeoQuery maxResults(int maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        if (this.location != null) {
            this.appendParameter("lat", this.location.getLatitude(), params);
            this.appendParameter("long", this.location.getLongitude(), params);
        }
        if (this.ip != null) {
            this.appendParameter("ip", this.ip, params);
        }
        this.appendParameter("accuracy", this.accuracy, params);
        this.appendParameter("query", this.query, params);
        this.appendParameter("granularity", this.granularity, params);
        this.appendParameter("max_results", this.maxResults, (List<HttpParameter>)params);
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<HttpParameter> params) {
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    private void appendParameter(String name, int value, List<HttpParameter> params) {
        if (0 < value) {
            params.add(new HttpParameter(name, String.valueOf(value)));
        }
    }

    private void appendParameter(String name, double value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoQuery geoQuery = (GeoQuery)o;
        if (this.maxResults != geoQuery.maxResults) {
            return false;
        }
        if (this.accuracy != null ? !this.accuracy.equals(geoQuery.accuracy) : geoQuery.accuracy != null) {
            return false;
        }
        if (this.granularity != null ? !this.granularity.equals(geoQuery.granularity) : geoQuery.granularity != null) {
            return false;
        }
        if (this.ip != null ? !this.ip.equals(geoQuery.ip) : geoQuery.ip != null) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(geoQuery.location) : geoQuery.location != null);
    }

    public int hashCode() {
        int result = this.location != null ? this.location.hashCode() : 0;
        result = 31 * result + (this.ip != null ? this.ip.hashCode() : 0);
        result = 31 * result + (this.accuracy != null ? this.accuracy.hashCode() : 0);
        result = 31 * result + (this.granularity != null ? this.granularity.hashCode() : 0);
        result = 31 * result + this.maxResults;
        return result;
    }

    public String toString() {
        return "GeoQuery{location=" + this.location + ", query='" + this.query + '\'' + ", ip='" + this.ip + '\'' + ", accuracy='" + this.accuracy + '\'' + ", granularity='" + this.granularity + '\'' + ", maxResults=" + this.maxResults + '}';
    }
}

