/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.Serializable;
import twitter4j.HttpResponse;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.OEmbed;
import twitter4j.TwitterException;
import twitter4j.TwitterObjectFactory;
import twitter4j.TwitterResponseImpl;
import twitter4j.conf.Configuration;

public class OEmbedJSONImpl
extends TwitterResponseImpl
implements OEmbed,
Serializable {
    private static final long serialVersionUID = -2207801480251709819L;
    private String html;
    private String authorName;
    private String url;
    private String version;
    private long cacheAge;
    private String authorURL;
    private int width;

    OEmbedJSONImpl(HttpResponse res, Configuration conf) throws TwitterException {
        super(res);
        JSONObject json = res.asJSONObject();
        this.init(json);
        if (conf.isJSONStoreEnabled()) {
            TwitterObjectFactory.clearThreadLocalMap();
            TwitterObjectFactory.registerJSONObject(this, json);
        }
    }

    OEmbedJSONImpl(JSONObject json) throws TwitterException {
        this.init(json);
    }

    private void init(JSONObject json) throws TwitterException {
        try {
            this.html = json.getString("html");
            this.authorName = json.getString("author_name");
            this.url = json.getString("url");
            this.version = json.getString("version");
            this.cacheAge = json.getLong("cache_age");
            this.authorURL = json.getString("author_url");
            this.width = json.getInt("width");
        }
        catch (JSONException jsone) {
            throw new TwitterException(jsone);
        }
    }

    public String getHtml() {
        return this.html;
    }

    public String getAuthorName() {
        return this.authorName;
    }

    public String getURL() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public long getCacheAge() {
        return this.cacheAge;
    }

    public String getAuthorURL() {
        return this.authorURL;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OEmbedJSONImpl that = (OEmbedJSONImpl)o;
        if (this.cacheAge != that.cacheAge) {
            return false;
        }
        if (this.width != that.width) {
            return false;
        }
        if (this.authorName != null ? !this.authorName.equals(that.authorName) : that.authorName != null) {
            return false;
        }
        if (this.authorURL != null ? !this.authorURL.equals(that.authorURL) : that.authorURL != null) {
            return false;
        }
        if (this.html != null ? !this.html.equals(that.html) : that.html != null) {
            return false;
        }
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        int result = this.html != null ? this.html.hashCode() : 0;
        result = 31 * result + (this.authorName != null ? this.authorName.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
        result = 31 * result + (int)(this.cacheAge ^ this.cacheAge >>> 32);
        result = 31 * result + (this.authorURL != null ? this.authorURL.hashCode() : 0);
        result = 31 * result + this.width;
        return result;
    }

    public String toString() {
        return "OEmbedJSONImpl{html='" + this.html + '\'' + ", authorName='" + this.authorName + '\'' + ", url='" + this.url + '\'' + ", version='" + this.version + '\'' + ", cacheAge=" + this.cacheAge + ", authorURL='" + this.authorURL + '\'' + ", width=" + this.width + '}';
    }
}

