/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.auth;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import twitter4j.BASE64Encoder;
import twitter4j.HttpClient;
import twitter4j.HttpClientFactory;
import twitter4j.HttpParameter;
import twitter4j.HttpRequest;
import twitter4j.HttpResponse;
import twitter4j.TwitterException;
import twitter4j.auth.Authorization;
import twitter4j.auth.OAuth2Support;
import twitter4j.auth.OAuth2Token;
import twitter4j.conf.Configuration;

public class OAuth2Authorization
implements Authorization,
Serializable,
OAuth2Support {
    private static final long serialVersionUID = -2895232598422218647L;
    private final Configuration conf;
    private final HttpClient http;
    private String consumerKey;
    private String consumerSecret;
    private OAuth2Token token;

    public OAuth2Authorization(Configuration conf) {
        this.conf = conf;
        this.setOAuthConsumer(conf.getOAuthConsumerKey(), conf.getOAuthConsumerSecret());
        this.http = HttpClientFactory.getInstance(conf.getHttpClientConfiguration());
    }

    public void setOAuthConsumer(String consumerKey, String consumerSecret) {
        this.consumerKey = consumerKey != null ? consumerKey : "";
        this.consumerSecret = consumerSecret != null ? consumerSecret : "";
    }

    public OAuth2Token getOAuth2Token() throws TwitterException {
        if (this.token != null) {
            throw new IllegalStateException("OAuth 2 Bearer Token is already available.");
        }
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("grant_type", "client_credentials")};
        HttpResponse res = this.http.post(this.conf.getOAuth2TokenURL(), params, this, null);
        if (res.getStatusCode() != 200) {
            throw new TwitterException("Obtaining OAuth 2 Bearer Token failed.", res);
        }
        this.token = new OAuth2Token(res);
        return this.token;
    }

    public void setOAuth2Token(OAuth2Token oauth2Token) {
        this.token = oauth2Token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateOAuth2Token() throws TwitterException {
        if (this.token == null) {
            throw new IllegalStateException("OAuth 2 Bearer Token is not available.");
        }
        HttpParameter[] params = new HttpParameter[]{new HttpParameter("access_token", this.token.getAccessToken())};
        OAuth2Token _token = this.token;
        boolean succeed = false;
        try {
            this.token = null;
            HttpResponse res = this.http.post(this.conf.getOAuth2InvalidateTokenURL(), params, this, null);
            if (res.getStatusCode() != 200) {
                throw new TwitterException("Invalidating OAuth 2 Bearer Token failed.", res);
            }
            succeed = true;
        }
        finally {
            if (!succeed) {
                this.token = _token;
            }
        }
    }

    public String getAuthorizationHeader(HttpRequest req) {
        if (this.token == null) {
            String credentials = "";
            try {
                credentials = URLEncoder.encode(this.consumerKey, "UTF-8") + ":" + URLEncoder.encode(this.consumerSecret, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return "Basic " + BASE64Encoder.encode(credentials.getBytes());
        }
        return this.token.generateAuthorizationHeader();
    }

    public boolean isEnabled() {
        return this.token != null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OAuth2Authorization)) {
            return false;
        }
        OAuth2Authorization that = (OAuth2Authorization)obj;
        if (this.consumerKey != null ? !this.consumerKey.equals(that.consumerKey) : that.consumerKey != null) {
            return false;
        }
        if (this.consumerSecret != null ? !this.consumerSecret.equals(that.consumerSecret) : that.consumerSecret != null) {
            return false;
        }
        return !(this.token != null ? !this.token.equals(that.token) : that.token != null);
    }

    public int hashCode() {
        int result = this.consumerKey != null ? this.consumerKey.hashCode() : 0;
        result = 31 * result + (this.consumerSecret != null ? this.consumerSecret.hashCode() : 0);
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "OAuth2Authorization{consumerKey='" + this.consumerKey + '\'' + ", consumerSecret='******************************************'" + ", token=" + (this.token == null ? "null" : this.token.toString()) + '}';
    }
}

