/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.conf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBase;

public final class PropertyConfiguration
extends ConfigurationBase
implements Serializable {
    private static final String DEBUG = "debug";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String HTTP_PRETTY_DEBUG = "http.prettyDebug";
    private static final String HTTP_GZIP = "http.gzip";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    private static final String HTTP_PROXY_HOST_FALLBACK = "http.proxyHost";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_PORT_FALLBACK = "http.proxyPort";
    private static final String HTTP_CONNECTION_TIMEOUT = "http.connectionTimeout";
    private static final String HTTP_READ_TIMEOUT = "http.readTimeout";
    private static final String HTTP_STREAMING_READ_TIMEOUT = "http.streamingReadTimeout";
    private static final String HTTP_RETRY_COUNT = "http.retryCount";
    private static final String HTTP_RETRY_INTERVAL_SECS = "http.retryIntervalSecs";
    private static final String OAUTH_CONSUMER_KEY = "oauth.consumerKey";
    private static final String OAUTH_CONSUMER_SECRET = "oauth.consumerSecret";
    private static final String OAUTH_ACCESS_TOKEN = "oauth.accessToken";
    private static final String OAUTH_ACCESS_TOKEN_SECRET = "oauth.accessTokenSecret";
    private static final String OAUTH2_TOKEN_TYPE = "oauth2.tokenType";
    private static final String OAUTH2_ACCESS_TOKEN = "oauth2.accessToken";
    private static final String OAUTH_REQUEST_TOKEN_URL = "oauth.requestTokenURL";
    private static final String OAUTH_AUTHORIZATION_URL = "oauth.authorizationURL";
    private static final String OAUTH_ACCESS_TOKEN_URL = "oauth.accessTokenURL";
    private static final String OAUTH_AUTHENTICATION_URL = "oauth.authenticationURL";
    private static final String OAUTH2_TOKEN_URL = "oauth2.tokenURL";
    private static final String OAUTH2_INVALIDATE_TOKEN_URL = "oauth2.invalidateTokenURL";
    private static final String REST_BASE_URL = "restBaseURL";
    private static final String STREAM_BASE_URL = "streamBaseURL";
    private static final String USER_STREAM_BASE_URL = "userStreamBaseURL";
    private static final String SITE_STREAM_BASE_URL = "siteStreamBaseURL";
    private static final String ASYNC_NUM_THREADS = "async.numThreads";
    private static final String ASYNC_DAEMON_ENABLED = "async.daemonEnabled";
    private static final String CONTRIBUTING_TO = "contributingTo";
    private static final String ASYNC_DISPATCHER_IMPL = "async.dispatcherImpl";
    private static final String INCLUDE_MY_RETWEET = "includeMyRetweet";
    private static final String INCLUDE_ENTITIES = "includeEntities";
    private static final String LOGGER_FACTORY = "loggerFactory";
    private static final String JSON_STORE_ENABLED = "jsonStoreEnabled";
    private static final String MBEAN_ENABLED = "mbeanEnabled";
    private static final String STREAM_USER_REPLIES_ALL = "stream.user.repliesAll";
    private static final String STREAM_USER_WITH_FOLLOWINGS = "stream.user.withFollowings";
    private static final String STREAM_STALL_WARNINGS_ENABLED = "stream.enableStallWarnings";
    private static final String APPLICATION_ONLY_AUTH_ENABLED = "enableApplicationOnlyAuth";
    private static final String MEDIA_PROVIDER = "media.provider";
    private static final String MEDIA_PROVIDER_API_KEY = "media.providerAPIKey";
    private static final String MEDIA_PROVIDER_PARAMETERS = "media.providerParameters";
    private static final long serialVersionUID = -7262615247923693252L;

    public PropertyConfiguration(InputStream is) {
        Properties props = new Properties();
        this.loadProperties(props, is);
        this.setFieldsWithTreePath(props, "/");
    }

    public PropertyConfiguration(Properties props) {
        this(props, "/");
    }

    public PropertyConfiguration(Properties props, String treePath) {
        this.setFieldsWithTreePath(props, treePath);
    }

    PropertyConfiguration(String treePath) {
        Properties props;
        try {
            props = (Properties)System.getProperties().clone();
            try {
                Map<String, String> envMap = System.getenv();
                for (String key : envMap.keySet()) {
                    props.setProperty(key, envMap.get(key));
                }
            }
            catch (SecurityException ignore) {
                // empty catch block
            }
            this.normalize(props);
        }
        catch (SecurityException ignore) {
            props = new Properties();
        }
        String TWITTER4J_PROPERTIES = "twitter4j.properties";
        this.loadProperties(props, "." + File.separatorChar + "twitter4j.properties");
        this.loadProperties(props, Configuration.class.getResourceAsStream("/twitter4j.properties"));
        this.loadProperties(props, Configuration.class.getResourceAsStream("/WEB-INF/twitter4j.properties"));
        try {
            this.loadProperties(props, new FileInputStream("WEB-INF/twitter4j.properties"));
        }
        catch (SecurityException ignore) {
        }
        catch (FileNotFoundException ignore) {
            // empty catch block
        }
        this.setFieldsWithTreePath(props, treePath);
    }

    PropertyConfiguration() {
        this("/");
    }

    private boolean notNull(Properties props, String prefix, String name) {
        return props.getProperty(prefix + name) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties(Properties props, String path) {
        FileInputStream fis = null;
        try {
            File file = new File(path);
            if (file.exists() && file.isFile()) {
                fis = new FileInputStream(file);
                props.load(fis);
                this.normalize(props);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception ignore) {
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException ignore) {}
        }
        return false;
    }

    private boolean loadProperties(Properties props, InputStream is) {
        try {
            props.load(is);
            this.normalize(props);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void normalize(Properties props) {
        Set<Object> keys = props.keySet();
        ArrayList<String> toBeNormalized = new ArrayList<String>(10);
        for (Object key : keys) {
            String keyStr = (String)key;
            if (-1 == keyStr.indexOf("twitter4j.")) continue;
            toBeNormalized.add(keyStr);
        }
        for (String keyStr : toBeNormalized) {
            String property = props.getProperty(keyStr);
            int index = keyStr.indexOf("twitter4j.");
            String newKey = keyStr.substring(0, index) + keyStr.substring(index + 10);
            props.setProperty(newKey, property);
        }
    }

    private void setFieldsWithTreePath(Properties props, String treePath) {
        this.setFieldsWithPrefix(props, "");
        String[] splitArray = treePath.split("/");
        String prefix = null;
        for (String split : splitArray) {
            if ("".equals(split)) continue;
            prefix = null == prefix ? split + "." : prefix + split + ".";
            this.setFieldsWithPrefix(props, prefix);
        }
    }

    private void setFieldsWithPrefix(Properties props, String prefix) {
        if (this.notNull(props, prefix, DEBUG)) {
            this.setDebug(this.getBoolean(props, prefix, DEBUG));
        }
        if (this.notNull(props, prefix, USER)) {
            this.setUser(this.getString(props, prefix, USER));
        }
        if (this.notNull(props, prefix, PASSWORD)) {
            this.setPassword(this.getString(props, prefix, PASSWORD));
        }
        if (this.notNull(props, prefix, HTTP_PRETTY_DEBUG)) {
            this.setPrettyDebugEnabled(this.getBoolean(props, prefix, HTTP_PRETTY_DEBUG));
        }
        if (this.notNull(props, prefix, HTTP_GZIP)) {
            this.setGZIPEnabled(this.getBoolean(props, prefix, HTTP_GZIP));
        }
        if (this.notNull(props, prefix, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(props, prefix, "http.proxyHost"));
        } else if (this.notNull(props, prefix, "http.proxyHost")) {
            this.setHttpProxyHost(this.getString(props, prefix, "http.proxyHost"));
        }
        if (this.notNull(props, prefix, HTTP_PROXY_USER)) {
            this.setHttpProxyUser(this.getString(props, prefix, HTTP_PROXY_USER));
        }
        if (this.notNull(props, prefix, HTTP_PROXY_PASSWORD)) {
            this.setHttpProxyPassword(this.getString(props, prefix, HTTP_PROXY_PASSWORD));
        }
        if (this.notNull(props, prefix, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(props, prefix, "http.proxyPort"));
        } else if (this.notNull(props, prefix, "http.proxyPort")) {
            this.setHttpProxyPort(this.getIntProperty(props, prefix, "http.proxyPort"));
        }
        if (this.notNull(props, prefix, HTTP_CONNECTION_TIMEOUT)) {
            this.setHttpConnectionTimeout(this.getIntProperty(props, prefix, HTTP_CONNECTION_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_READ_TIMEOUT)) {
            this.setHttpReadTimeout(this.getIntProperty(props, prefix, HTTP_READ_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_STREAMING_READ_TIMEOUT)) {
            this.setHttpStreamingReadTimeout(this.getIntProperty(props, prefix, HTTP_STREAMING_READ_TIMEOUT));
        }
        if (this.notNull(props, prefix, HTTP_RETRY_COUNT)) {
            this.setHttpRetryCount(this.getIntProperty(props, prefix, HTTP_RETRY_COUNT));
        }
        if (this.notNull(props, prefix, HTTP_RETRY_INTERVAL_SECS)) {
            this.setHttpRetryIntervalSeconds(this.getIntProperty(props, prefix, HTTP_RETRY_INTERVAL_SECS));
        }
        if (this.notNull(props, prefix, OAUTH_CONSUMER_KEY)) {
            this.setOAuthConsumerKey(this.getString(props, prefix, OAUTH_CONSUMER_KEY));
        }
        if (this.notNull(props, prefix, OAUTH_CONSUMER_SECRET)) {
            this.setOAuthConsumerSecret(this.getString(props, prefix, OAUTH_CONSUMER_SECRET));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN)) {
            this.setOAuthAccessToken(this.getString(props, prefix, OAUTH_ACCESS_TOKEN));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN_SECRET)) {
            this.setOAuthAccessTokenSecret(this.getString(props, prefix, OAUTH_ACCESS_TOKEN_SECRET));
        }
        if (this.notNull(props, prefix, OAUTH2_TOKEN_TYPE)) {
            this.setOAuth2TokenType(this.getString(props, prefix, OAUTH2_TOKEN_TYPE));
        }
        if (this.notNull(props, prefix, OAUTH2_ACCESS_TOKEN)) {
            this.setOAuth2AccessToken(this.getString(props, prefix, OAUTH2_ACCESS_TOKEN));
        }
        if (this.notNull(props, prefix, ASYNC_NUM_THREADS)) {
            this.setAsyncNumThreads(this.getIntProperty(props, prefix, ASYNC_NUM_THREADS));
        }
        if (this.notNull(props, prefix, ASYNC_DAEMON_ENABLED)) {
            this.setDaemonEnabled(this.getBoolean(props, prefix, ASYNC_DAEMON_ENABLED));
        }
        if (this.notNull(props, prefix, CONTRIBUTING_TO)) {
            this.setContributingTo(this.getLongProperty(props, prefix, CONTRIBUTING_TO));
        }
        if (this.notNull(props, prefix, ASYNC_DISPATCHER_IMPL)) {
            this.setDispatcherImpl(this.getString(props, prefix, ASYNC_DISPATCHER_IMPL));
        }
        if (this.notNull(props, prefix, OAUTH_REQUEST_TOKEN_URL)) {
            this.setOAuthRequestTokenURL(this.getString(props, prefix, OAUTH_REQUEST_TOKEN_URL));
        }
        if (this.notNull(props, prefix, OAUTH_AUTHORIZATION_URL)) {
            this.setOAuthAuthorizationURL(this.getString(props, prefix, OAUTH_AUTHORIZATION_URL));
        }
        if (this.notNull(props, prefix, OAUTH_ACCESS_TOKEN_URL)) {
            this.setOAuthAccessTokenURL(this.getString(props, prefix, OAUTH_ACCESS_TOKEN_URL));
        }
        if (this.notNull(props, prefix, OAUTH_AUTHENTICATION_URL)) {
            this.setOAuthAuthenticationURL(this.getString(props, prefix, OAUTH_AUTHENTICATION_URL));
        }
        if (this.notNull(props, prefix, OAUTH2_TOKEN_URL)) {
            this.setOAuth2TokenURL(this.getString(props, prefix, OAUTH2_TOKEN_URL));
        }
        if (this.notNull(props, prefix, OAUTH2_INVALIDATE_TOKEN_URL)) {
            this.setOAuth2InvalidateTokenURL(this.getString(props, prefix, OAUTH2_INVALIDATE_TOKEN_URL));
        }
        if (this.notNull(props, prefix, REST_BASE_URL)) {
            this.setRestBaseURL(this.getString(props, prefix, REST_BASE_URL));
        }
        if (this.notNull(props, prefix, STREAM_BASE_URL)) {
            this.setStreamBaseURL(this.getString(props, prefix, STREAM_BASE_URL));
        }
        if (this.notNull(props, prefix, USER_STREAM_BASE_URL)) {
            this.setUserStreamBaseURL(this.getString(props, prefix, USER_STREAM_BASE_URL));
        }
        if (this.notNull(props, prefix, SITE_STREAM_BASE_URL)) {
            this.setSiteStreamBaseURL(this.getString(props, prefix, SITE_STREAM_BASE_URL));
        }
        if (this.notNull(props, prefix, INCLUDE_MY_RETWEET)) {
            this.setIncludeMyRetweetEnabled(this.getBoolean(props, prefix, INCLUDE_MY_RETWEET));
        }
        if (this.notNull(props, prefix, INCLUDE_ENTITIES)) {
            this.setIncludeEntitiesEnabled(this.getBoolean(props, prefix, INCLUDE_ENTITIES));
        }
        if (this.notNull(props, prefix, LOGGER_FACTORY)) {
            this.setLoggerFactory(this.getString(props, prefix, LOGGER_FACTORY));
        }
        if (this.notNull(props, prefix, JSON_STORE_ENABLED)) {
            this.setJSONStoreEnabled(this.getBoolean(props, prefix, JSON_STORE_ENABLED));
        }
        if (this.notNull(props, prefix, MBEAN_ENABLED)) {
            this.setMBeanEnabled(this.getBoolean(props, prefix, MBEAN_ENABLED));
        }
        if (this.notNull(props, prefix, STREAM_USER_REPLIES_ALL)) {
            this.setUserStreamRepliesAllEnabled(this.getBoolean(props, prefix, STREAM_USER_REPLIES_ALL));
        }
        if (this.notNull(props, prefix, STREAM_USER_WITH_FOLLOWINGS)) {
            this.setUserStreamWithFollowingsEnabled(this.getBoolean(props, prefix, STREAM_USER_WITH_FOLLOWINGS));
        }
        if (this.notNull(props, prefix, STREAM_STALL_WARNINGS_ENABLED)) {
            this.setStallWarningsEnabled(this.getBoolean(props, prefix, STREAM_STALL_WARNINGS_ENABLED));
        }
        if (this.notNull(props, prefix, APPLICATION_ONLY_AUTH_ENABLED)) {
            this.setApplicationOnlyAuthEnabled(this.getBoolean(props, prefix, APPLICATION_ONLY_AUTH_ENABLED));
        }
        if (this.notNull(props, prefix, MEDIA_PROVIDER)) {
            this.setMediaProvider(this.getString(props, prefix, MEDIA_PROVIDER));
        }
        if (this.notNull(props, prefix, MEDIA_PROVIDER_API_KEY)) {
            this.setMediaProviderAPIKey(this.getString(props, prefix, MEDIA_PROVIDER_API_KEY));
        }
        if (this.notNull(props, prefix, MEDIA_PROVIDER_PARAMETERS)) {
            String[] propsAry = this.getString(props, prefix, MEDIA_PROVIDER_PARAMETERS).split("&");
            Properties p = new Properties();
            for (String str : propsAry) {
                String[] parameter = str.split("=");
                p.setProperty(parameter[0], parameter[1]);
            }
            this.setMediaProviderParameters(p);
        }
        this.cacheInstance();
    }

    boolean getBoolean(Properties props, String prefix, String name) {
        String value = props.getProperty(prefix + name);
        return Boolean.valueOf(value);
    }

    int getIntProperty(Properties props, String prefix, String name) {
        String value = props.getProperty(prefix + name);
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    long getLongProperty(Properties props, String prefix, String name) {
        String value = props.getProperty(prefix + name);
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return -1L;
        }
    }

    String getString(Properties props, String prefix, String name) {
        return props.getProperty(prefix + name);
    }

    protected Object readResolve() throws ObjectStreamException {
        return super.readResolve();
    }
}

