/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Assert;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.FieldType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class AbstractObjectEditorPanel
extends ObjectEditorPanel {
    public final Signal fieldGotFocus = Signals.createSignal(String.class, (String)"fieldName", FieldPanel.class, (String)"fieldPanel");
    public static final Signal editObjectChanged = Signals.createSignal();
    private ObjectTemplate objTemplate;
    private ObjectManager manager;
    private Object editedObject;
    private Map<String, FieldPanel> fieldPanelsByName;
    private Map<FieldPanel, String> fieldNamesByPanel;
    private boolean init = false;
    public static final Color HIGHLIGHT_COLOR = new Color(150, 180, 200);

    public abstract void initComponents();

    @Override
    public void init(ObjectManager newManager, ObjectTemplate objectTemplate, Object obj) {
        Assert.isTrue((objectTemplate != null ? 1 : 0) != 0, (String)("Object template should not be null for :" + (obj != null ? obj.getClass() : null)));
        Assert.isTrue((newManager != null ? 1 : 0) != 0, (String)"Object manager should not be null");
        this.objTemplate = objectTemplate;
        this.manager = newManager;
        this.objTemplate.setManager(this.manager);
        if (obj != null) {
            Assert.isTrue((boolean)this.objTemplate.objectBelongs(obj), (String)("Object <" + this.editedObject + "> does not belong to template \"" + this.objTemplate + "\""));
        }
        this.fieldPanelsByName = new LinkedHashMap<String, FieldPanel>();
        this.fieldNamesByPanel = new HashMap<FieldPanel, String>();
        this.removeAll();
        this.init = true;
        this.initComponents();
        this.setEditedObject(obj);
    }

    protected FieldPanel createFieldPanel(String fieldName) {
        FieldType type = this.objTemplate.getFieldType(fieldName);
        if (type == null) {
            throw new IllegalArgumentException("Cannot find FieldType of field " + fieldName);
        }
        FieldPanel panel = type.getPanel(this.manager);
        String instructionsText = this.objTemplate.getInstructions(fieldName);
        panel.setToolTipText(instructionsText);
        if (panel.getPrimaryComponent().getToolTipText() == null) {
            panel.getPrimaryComponent().setToolTipText(instructionsText);
        }
        return panel;
    }

    public final FieldPanel getFieldPanel(PropertiedObject.Property property) {
        this.doCheckInit();
        return this.getFieldPanel(property.getUserVisibleLabel());
    }

    public FieldPanel getFieldPanel(String fieldName) {
        this.doCheckInit();
        if (this.fieldPanelsByName.containsKey(fieldName)) {
            return this.fieldPanelsByName.get(fieldName);
        }
        FieldPanel panel = this.createFieldPanel(fieldName);
        panel.setName(fieldName);
        panel.okPressed.connect((Object)this.okKeyPressed, "emit");
        panel.cancelPressed.connect((Object)this.cancelKeyPressed, "emit");
        panel.focusGained.connect((Object)this, "gotFocusGained");
        panel.focusLost.connect((Object)this, "gotFocusLost");
        this.fieldPanelsByName.put(fieldName, panel);
        this.fieldNamesByPanel.put(panel, fieldName);
        return panel;
    }

    public final String getFieldPanelName(FieldPanel panel) {
        this.doCheckInit();
        if (this.fieldNamesByPanel.containsKey(panel)) {
            return this.fieldNamesByPanel.get(panel);
        }
        throw new IllegalArgumentException("FieldPanel does not belong to this ObjectEditorPanel: " + panel);
    }

    public Object getFieldValue(String fieldName) {
        this.doCheckInit();
        return this.getFieldPanel(fieldName).getValue();
    }

    @Override
    public void cancelObject() {
    }

    public void gotFocusGained(FieldPanel panel) {
        this.doCheckInit();
        String name = this.fieldNamesByPanel.get(panel);
        if (name == null) {
            throw new IllegalArgumentException("Cannot find field panel " + panel);
        }
        this.fieldGotFocus.emit((Object)name, (Object)panel);
    }

    public void gotFocusLost(FieldPanel lostFocus) {
        this.repaint();
    }

    @Override
    public void saveObject() {
        this.doCheckInit();
        if (this.editedObject == null) {
            this.editedObject = this.constructNewObject();
        }
        for (String name : this.fieldPanelsByName.keySet()) {
            FieldPanel panel = this.fieldPanelsByName.get(name);
            Object value = panel.getValue();
            this.saveObjectProperty(name, value);
        }
    }

    protected Object constructNewObject() {
        return this.objTemplate.createNewObject();
    }

    protected void saveObjectProperty(String field, Object value) {
        this.objTemplate.setObjectProperty(this.editedObject, field, value);
    }

    public String[] getInvalidFields() {
        ArrayList<String> invalidFields = new ArrayList<String>();
        for (String name : this.fieldPanelsByName.keySet()) {
            FieldPanel panel = this.fieldPanelsByName.get(name);
            Object type = panel.getFieldType();
            if (type.isValidValue(panel.getValue())) continue;
            invalidFields.add(name);
        }
        return invalidFields.toArray(new String[invalidFields.size()]);
    }

    public boolean isObjectValid() {
        return this.getInvalidFields().length == 0;
    }

    @Override
    public boolean requestCancelAllowed() {
        return true;
    }

    @Override
    public boolean requestSaveAllowed() {
        boolean valid = this.isObjectValid();
        String[] invalidFields = this.getInvalidFields();
        if (!valid) {
            String messageString = "<ul>";
            for (int i = 0; i < invalidFields.length; ++i) {
                messageString = messageString + "<li> " + invalidFields[i];
            }
            messageString = messageString + "</ul>";
            Dialogs.showErrorDialog("Invalid Settings", "<html>The following fields have not been set correctly! " + messageString + "  Please ensure they are correct, or cancel.</html>");
        }
        return valid;
    }

    public ObjectManager getObjectManager() {
        this.doCheckInit();
        return this.manager;
    }

    @Override
    public ObjectTemplate getTemplate() {
        this.doCheckInit();
        return this.objTemplate;
    }

    @Override
    public Object getEditedObject() {
        this.doCheckInit();
        return this.editedObject;
    }

    public void setEditedObject(Object newObject) {
        this.doCheckInit();
        if (this.editedObject == newObject) {
            return;
        }
        this.editedObject = newObject;
        for (String name : this.fieldPanelsByName.keySet()) {
            FieldPanel panel = this.fieldPanelsByName.get(name);
            panel.setEnabled(true);
            if (this.editedObject != null) {
                Object prop = this.objTemplate.getObjectProperty(this.editedObject, name);
                panel.setValue(prop);
                continue;
            }
            panel.reset();
        }
        editObjectChanged.emit();
    }

    public void setNoEditedObject() {
        this.doCheckInit();
        this.editedObject = null;
        for (String name : this.fieldPanelsByName.keySet()) {
            FieldPanel panel = this.fieldPanelsByName.get(name);
            panel.reset();
            panel.setEnabled(false);
        }
    }

    @Override
    public boolean isNewObject() {
        return this.editedObject == null;
    }

    @Override
    public boolean requestCloseAllowed() {
        return false;
    }

    @Override
    public int getDialogMode() {
        return 0;
    }

    private void doCheckInit() {
        Assert.isTrue((boolean)this.init, (String)"Must initialize before using");
    }
}

