/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.util.image.IconLoader;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.components.actions.OfficematePermissableAction;
import ordermate.database.users.Permission;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class AddRemoveButtonPanel
extends JPanel {
    public final Signal addPressed = Signals.createSignal();
    public final Signal editPressed = Signals.createSignal();
    public final Signal removePressed = Signals.createSignal();
    public final Signal printPressed = Signals.createSignal();
    public final Signal refreshPressed = Signals.createSignal();
    public final Signal searchPressed = Signals.createSignal();
    public final Signal spinUpPressed = Signals.createSignal();
    public final Signal spinDownPressed = Signals.createSignal();
    private AbstractButton addButton;
    private AbstractButton removeButton;
    private AbstractButton editButton;
    private AbstractButton spinUpButton;
    private AbstractButton spinDownButton;
    private AbstractButton printButton;
    private AbstractButton refreshButton;
    private AbstractButton searchButton;

    private AddRemoveButtonPanel(boolean allowAdd, boolean allowEdit, boolean allowRemove, boolean allowPrint, boolean allowRefresh, boolean allowSearch, boolean allowSpinUp, boolean allowSpinDown, Permission addPerm, Permission editPerm, Permission removePerm) {
        super(new GridLayout(0, 1));
        if (allowAdd) {
            this.addButton = this.setupButton("Add", addPerm, IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add...", this.addPressed);
        }
        if (allowEdit) {
            this.editButton = this.setupButton("Edit", editPerm, IconLoader.get((String)"/ordermate/images/edit_icon22.png"), "Edit...", this.editPressed);
        }
        if (allowRemove) {
            this.removeButton = this.setupButton("Remove", removePerm, IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove", this.removePressed);
        }
        if (allowPrint) {
            this.printButton = this.setupButton("Print", IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Print...", this.printPressed);
        }
        if (allowRefresh) {
            this.refreshButton = this.setupButton("Refresh", IconLoader.get((String)"/ordermate/images/refresh_icon22.png"), "Refresh", this.refreshPressed);
        }
        if (allowSearch) {
            this.searchButton = this.setupButton("Search", IconLoader.get((String)"/ordermate/images/search22.png"), "Search", this.searchPressed);
        }
        if (allowSpinUp) {
            this.spinUpButton = this.setupButton("Spin Up", IconLoader.get((String)"/ordermate/images/uparrow.png"), "Spin up", this.spinUpPressed);
        }
        if (allowSpinDown) {
            this.spinDownButton = this.setupButton("Spin Down", IconLoader.get((String)"/ordermate/images/downarrow.png"), "Spin Down", this.spinDownPressed);
        }
    }

    private AbstractButton setupButton(String name, Icon buttonIcon, String tooltip, Signal toEmit) {
        return this.setupButton(name, null, buttonIcon, tooltip, toEmit);
    }

    private AbstractButton setupButton(String name, Permission permission, Icon buttonIcon, String tooltip, final Signal toEmit) {
        JButton button = new JButton();
        button.setAction((Action)((Object)new OfficematePermissableAction("", permission, buttonIcon, tooltip){

            public void actionPerformed(ActionEvent e) {
                toEmit.emit();
            }
        }));
        button.setName(name);
        this.add(button);
        return button;
    }

    public AddRemoveButtonPanel(boolean allowAdd, boolean allowEdit, boolean allowRemove, boolean allowPrint, boolean allowRefresh, boolean allowSearch, Permission addPerm, Permission editPerm, Permission removePerm) {
        this(allowAdd, allowEdit, allowRemove, allowPrint, allowRefresh, allowSearch, false, false, addPerm, editPerm, removePerm);
    }

    public void updateButtonStates(Object test) {
        boolean notNull = test != null;
        this.enableAddButton(true);
        this.enableRemoveButton(notNull);
        this.enableEditButton(notNull);
        this.enablePrintButton(true);
        this.enableRefreshButton(true);
    }

    public void enableAddButton(boolean enable) {
        if (this.addButton != null) {
            this.addButton.getAction().setEnabled(enable);
        }
    }

    public void enableRemoveButton(boolean enable) {
        if (this.removeButton != null) {
            this.removeButton.getAction().setEnabled(enable);
        }
    }

    public void enableEditButton(boolean enable) {
        if (this.editButton != null) {
            this.editButton.getAction().setEnabled(enable);
        }
    }

    public void enablePrintButton(boolean enable) {
        if (this.printButton != null) {
            this.printButton.getAction().setEnabled(enable);
        }
    }

    public void enableRefreshButton(boolean enable) {
        if (this.refreshButton != null) {
            this.refreshButton.getAction().setEnabled(enable);
        }
    }

    public void enableSearchButton(boolean enable) {
        if (this.searchButton != null) {
            this.searchButton.getAction().setEnabled(enable);
        }
    }

    public void enableSpinButtons(boolean enable) {
        if (this.spinUpButton != null) {
            this.spinUpButton.getAction().setEnabled(enable);
        }
        if (this.spinDownButton != null) {
            this.spinDownButton.getAction().setEnabled(enable);
        }
    }

    @Override
    public void setEnabled(boolean enable) {
        this.enableAddButton(enable);
        this.enableEditButton(enable);
        this.enableRemoveButton(enable);
        this.enablePrintButton(enable);
        this.enableRefreshButton(enable);
        this.enableSearchButton(enable);
        this.enableSpinButtons(enable);
    }

    public void addAddActionListener(ActionListener al) {
        this.addButton.addActionListener(al);
    }

    public void addRemoveActionListener(ActionListener al) {
        this.removeButton.addActionListener(al);
    }

    public void addEditActionListener(ActionListener al) {
        this.editButton.addActionListener(al);
    }

    public Action getAddAction() {
        return this.addButton.getAction();
    }

    public Action getRemoveAction() {
        return this.removeButton.getAction();
    }

    public Action getEditAction() {
        return this.editButton.getAction();
    }

    public void setAddBtnPermission(Permission permission) {
        this.setButtonPermission(this.addButton, this.addPressed, permission);
    }

    public void setRemoveBtnPermission(Permission permission) {
        this.setButtonPermission(this.removeButton, this.removePressed, permission);
    }

    private void setButtonPermission(AbstractButton button, final Signal toEmit, Permission permission) {
        button.setAction((Action)((Object)new OfficematePermissableAction("", permission, button.getIcon(), button.getToolTipText()){

            public void actionPerformed(ActionEvent e) {
                toEmit.emit();
            }
        }));
    }

    public static class AddRemovePanelBuilder {
        private boolean allowAdding = true;
        private boolean allowEditing = true;
        private boolean allowRemoving = true;
        private boolean allowPrinting;
        private boolean allowRefreshing;
        private boolean allowSearching;
        private boolean allowSpinUp;
        private boolean allowSpinDown;
        private Permission addPerm = null;
        private Permission editPerm = null;
        private Permission removePerm = null;

        public AddRemovePanelBuilder setAllowAdd(boolean allowAdd) {
            this.allowAdding = allowAdd;
            return this;
        }

        public AddRemovePanelBuilder setAllowEdit(boolean allowEdit) {
            this.allowEditing = allowEdit;
            return this;
        }

        public AddRemovePanelBuilder setAllowRemove(boolean allowRemove) {
            this.allowRemoving = allowRemove;
            return this;
        }

        public AddRemovePanelBuilder setAllowPrint(boolean allowPrint) {
            this.allowPrinting = allowPrint;
            return this;
        }

        public AddRemovePanelBuilder setAllowRefresh(boolean allowRefresh) {
            this.allowRefreshing = allowRefresh;
            return this;
        }

        public AddRemovePanelBuilder setAllowSearch(boolean allowSearch) {
            this.allowSearching = allowSearch;
            return this;
        }

        public AddRemovePanelBuilder setAddPermission(Permission addPermission) {
            this.addPerm = addPermission;
            return this;
        }

        public AddRemovePanelBuilder setEditPermission(Permission editPermission) {
            this.editPerm = editPermission;
            return this;
        }

        public AddRemovePanelBuilder setRemovePermission(Permission removePermission) {
            this.removePerm = removePermission;
            return this;
        }

        public AddRemovePanelBuilder setAllowSpinning(boolean allowIt) {
            this.allowSpinDown = allowIt;
            this.allowSpinUp = allowIt;
            return this;
        }

        public AddRemovePanelBuilder setCrudPermissions(Permission permission) {
            this.setAddPermission(permission);
            this.setRemovePermission(permission);
            this.setEditPermission(permission);
            return this;
        }

        public AddRemoveButtonPanel build() {
            return new AddRemoveButtonPanel(this.allowAdding, this.allowEditing, this.allowRemoving, this.allowPrinting, this.allowRefreshing, this.allowSearching, this.allowSpinUp, this.allowSpinDown, this.addPerm, this.editPerm, this.removePerm);
        }
    }
}

