/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.guicore.task.CompositeTask;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.Dialogs;
import ordermate.OrderMate;
import ordermate.serverconnection.ConnectionManagerScreen;

public class AdminConnectionPanel
extends JPanel
implements ActionListener,
ConnectionManagerScreen {
    private JButton exitButton;
    private JLabel retryLabel;
    private JDialog dialog;
    private boolean showing;
    private boolean allTasksStarted = false;

    public AdminConnectionPanel() {
        this.setLayout((LayoutManager)new GraphPaperLayout(20, 20));
        JLabel messageLabel = new JLabel("Connecting to server. . .");
        Font currentFont = messageLabel.getFont();
        messageLabel.setFont(currentFont.deriveFont((float)(currentFont.getSize() + 4)));
        messageLabel.setHorizontalAlignment(0);
        this.add((Component)messageLabel, new Rectangle(1, 1, 18, 2));
        JLabel messageLabel2 = new JLabel("Officemate is trying to reconnect ...");
        messageLabel2.setHorizontalAlignment(0);
        this.add((Component)messageLabel2, new Rectangle(1, 4, 18, 1));
        this.retryLabel = new JLabel();
        this.retryLabel.setHorizontalAlignment(0);
        this.add((Component)this.retryLabel, new Rectangle(1, 12, 18, 1));
        JLabel imageLabel = new JLabel(new ImageIcon(this.getClass().getResource("/ordermate/images/reconnect.gif")));
        this.add((Component)imageLabel, new Rectangle(4, 8, 12, 4));
        this.exitButton = new JButton("Exit");
        this.exitButton.setIcon(new ImageIcon(this.getClass().getResource("/ordermate/images/exit.png")));
        this.exitButton.addActionListener(this);
        this.add((Component)this.exitButton, new Rectangle(7, 16, 6, 3));
        this.setSize(400, 400);
        CompositeTask.allTasksStarted.connect((Object)this, "setAllTasksStarted");
    }

    private void setAllTasksStarted() {
        this.allTasksStarted = true;
    }

    public void setNumRetries(String server, int numRetry) {
        String text = "Tried to connect to " + server + " " + numRetry;
        text = numRetry == 1 ? text + " time" : text + " times";
        this.retryLabel.setText(text);
    }

    public void showConnectionInterface() {
        if (!this.showing && this.allTasksStarted) {
            this.showing = true;
            this.dialog = new JDialog((Frame)null, "Disconnected from server...", true);
            this.dialog.getContentPane().add(this);
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(null);
            this.dialog.setVisible(true);
        }
    }

    public void hideConnectionInterface() {
        if (this.showing) {
            OrderMate.LOG.info("Hide connection interface");
            this.dialog.setVisible(false);
            this.dialog.dispose();
            this.showing = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.exitButton)) {
            OrderMate.LOG.warn("Reconnection failed, exiting OfficeMate at user request.");
            try {
                GuiApp.getAppComplex().getApplicationSecurity().exit();
            }
            catch (Exception ex) {
                OrderMate.LOG.error("Exiting officemate failed, exiting JVM with system.exit");
                OfficeMate.exit(-1);
            }
        }
    }

    public void displayVersionWarningDialog(String serverVersion) {
        Dialogs.showErrorDialog("Server version mismatch", "Server version " + serverVersion + " does not match the version " + OrderMate.VERSION);
    }

    public void connectedToServer(boolean isRedundant, String connectedServer) {
        OfficeMate.getInstance().setFailoverMode(isRedundant);
    }
}

