/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.util.image.IconLoader;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import ordermate.database.misc.SystemProperty;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXDatePicker;

public class DateRangePanel
extends JPanel {
    private static final int MILLIS_IN_DAY = 86400000;
    public final Signal datesChanged = Signals.createSignal(java.util.Date.class, (String)"newStartDate", java.util.Date.class, (String)"newEndDate");
    private boolean usesTradingDayBoundaries = true;
    private boolean useGoButton = true;
    private JXDatePicker startDate;
    private JXDatePicker endDate;
    private JButton goButton;

    public DateRangePanel() {
        this(true);
    }

    public DateRangePanel(boolean shouldUseGoButton) {
        this.useGoButton = shouldUseGoButton;
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        this.startDate = new JXDatePicker(cal.getTime());
        this.startDate.setFormats(formats);
        this.startDate.setName("startDate");
        Dimension size = this.startDate.getPreferredSize();
        size.width += 50;
        this.startDate.setPreferredSize(size);
        this.endDate = new JXDatePicker(new java.util.Date(System.currentTimeMillis()));
        this.endDate.setName("endDate");
        this.endDate.setFormats(formats);
        size = this.endDate.getPreferredSize();
        size.width += 50;
        this.endDate.setPreferredSize(size);
        if (!shouldUseGoButton) {
            PropertyChangeListener dateChanged = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    DateRangePanel.this.datesChanged.emit((Object)DateRangePanel.this.getStartDate(), (Object)DateRangePanel.this.getEndDate());
                }
            };
            this.startDate.addPropertyChangeListener("date", dateChanged);
            this.endDate.addPropertyChangeListener("date", dateChanged);
        }
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref, 3dlu, left:pref");
        this.setLayout((LayoutManager)layout);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.append("From:", (Component)this.startDate);
        builder.nextLine();
        builder.append("To:", (Component)this.endDate);
        if (this.useGoButton) {
            this.goButton = new JButton(IconLoader.get((String)"/ordermate/images/button_ok.png"));
            this.goButton.setToolTipText("Go");
            this.goButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DateRangePanel.this.datesChanged.emit((Object)DateRangePanel.this.getStartDate(), (Object)DateRangePanel.this.getEndDate());
                }
            });
            CellConstraints cc = new CellConstraints();
            builder.add((Component)this.goButton, cc.xywh(5, 1, 1, 3));
        }
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    public JComponent getStartDateChooser() {
        return this.startDate;
    }

    public JComponent getEndDateChooser() {
        return this.endDate;
    }

    public boolean usesTradingDayBoundaries() {
        return this.usesTradingDayBoundaries;
    }

    public void setUsesTradingDayBoundaries(boolean b) {
        this.usesTradingDayBoundaries = b;
    }

    public java.util.Date getStartDate() {
        if (!this.usesTradingDayBoundaries) {
            java.util.Date date = this.startDate.getDate();
            return date;
        }
        return DateRangePanel.convertDateToStartOfTradingDayTime(this.startDate.getDate());
    }

    private static java.util.Date convertDateToStartOfTradingDayTime(java.util.Date baseDate) {
        java.util.Date changeDayTime = SystemProperty.getInstance().getChangeDayTime();
        GregorianCalendar changeDayCal = new GregorianCalendar();
        changeDayCal.setTime(changeDayTime);
        int changeDayH = changeDayCal.get(11);
        int changeDayM = changeDayCal.get(12);
        int changeDayS = changeDayCal.get(13);
        GregorianCalendar dateCal = new GregorianCalendar();
        dateCal.setTime(baseDate);
        dateCal.set(11, changeDayH);
        dateCal.set(12, changeDayM);
        dateCal.set(13, changeDayS);
        return new java.util.Date(dateCal.getTimeInMillis());
    }

    public java.util.Date getEndDate() {
        if (!this.usesTradingDayBoundaries) {
            java.util.Date date = this.endDate.getDate();
            return date;
        }
        java.util.Date retval = DateRangePanel.convertDateToStartOfTradingDayTime(this.endDate.getDate());
        retval.setTime(retval.getTime() + 86400000L);
        return retval;
    }

    public java.util.Date getApparentEndDate() {
        return this.endDate.getDate();
    }

    public Date getSQLStartDate() {
        return new Date(this.getStartDate().getTime());
    }

    public Date getSQLEndDate() {
        return new Date(this.getEndDate().getTime());
    }

    public void setStartDate(java.util.Date date) {
        this.startDate.setDate(date);
    }

    public void setEndDate(java.util.Date date) {
        this.endDate.setDate(date);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.startDate.setEnabled(enabled);
        this.endDate.setEnabled(enabled);
        if (this.goButton != null) {
            this.goButton.setEnabled(enabled);
        }
    }
}

