/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.image.IconLoader;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.JXDatePicker;

public class DateTimeRangePanel
extends JPanel {
    public final Signal datesChanged = Signals.createSignal(java.util.Date.class, (String)"newStartDate", java.util.Date.class, (String)"newEndDate");
    private JXDatePicker startDate;
    private JSpinner startTime;
    private JXDatePicker endDate;
    private JSpinner endTime;
    private JButton goButton;

    public DateTimeRangePanel() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        this.startDate = new JXDatePicker(cal.getTime());
        this.startDate.setName("From date");
        this.startDate.setFormats(formats);
        Dimension size = this.startDate.getPreferredSize();
        size.width += 50;
        this.startDate.setPreferredSize(size);
        java.util.Date date = new java.util.Date();
        SpinnerDateModel sm = new SpinnerDateModel(date, null, null, 12);
        this.startTime = new JSpinner(sm);
        this.startTime.setName("From time");
        JSpinner.DateEditor de = new JSpinner.DateEditor(this.startTime, "hh:mm a");
        this.startTime.setEditor(de);
        this.endDate = new JXDatePicker(new java.util.Date(System.currentTimeMillis()));
        this.endDate.setName("To date");
        this.endDate.setFormats(formats);
        size = this.endDate.getPreferredSize();
        size.width += 50;
        this.endDate.setPreferredSize(size);
        sm = new SpinnerDateModel(date, null, null, 12);
        this.endTime = new JSpinner(sm);
        this.endTime.setName("To time");
        de = new JSpinner.DateEditor(this.endTime, "hh:mm a");
        this.endTime.setEditor(de);
        this.goButton = new JButton(IconLoader.get((String)"/ordermate/images/button_ok.png"));
        this.goButton.setToolTipText("Go");
        this.goButton.setName("Go");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DateTimeRangePanel.this.datesChanged.emit((Object)DateTimeRangePanel.this.getStartDate(), (Object)DateTimeRangePanel.this.getEndDate());
            }
        });
        FormLayout layout = new FormLayout("right:pref, 3dlu, left:pref, 3dlu, left:pref, 3dlu, left:pref");
        this.setLayout((LayoutManager)layout);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.append("From:", (Component)this.startDate, (Component)this.startTime);
        builder.nextLine();
        builder.append("To:", (Component)this.endDate, (Component)this.endTime);
        CellConstraints cc = new CellConstraints();
        builder.add((Component)this.goButton, cc.xywh(7, 1, 1, 3));
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
    }

    public java.util.Date getStartDate() {
        return DateTimeUtils.mergeDateAndTime((java.util.Date)this.startDate.getDate(), (java.util.Date)((java.util.Date)this.startTime.getValue()));
    }

    public java.util.Date getEndDate() {
        return DateTimeUtils.mergeDateAndTime((java.util.Date)this.endDate.getDate(), (java.util.Date)((java.util.Date)this.endTime.getValue()));
    }

    public Date getSQLStartDate() {
        return new Date(this.getStartDate().getTime());
    }

    public Date getSQLEndDate() {
        return new Date(this.getEndDate().getTime());
    }

    public void setStartDate(java.util.Date date) {
        this.startDate.setDate(date);
        this.startTime.setValue(date);
    }

    public void setEndDate(java.util.Date date) {
        this.endDate.setDate(date);
        this.endTime.setValue(date);
    }

    @Override
    public void setEnabled(boolean b) {
        this.startDate.setEnabled(b);
        this.startTime.setEnabled(b);
        this.endDate.setEnabled(b);
        this.endTime.setEnabled(b);
        this.goButton.setEnabled(b);
    }
}

