/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.util.Assert;
import au.com.ordermate.util.Price;
import java.util.Comparator;
import java.util.List;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.IntFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.QuantityFieldType;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import stockmate.database.interfaces.stock.MeasureUnitI;

public final class ObjectUtils {
    public static Quantity getTotalQty(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, QuantityFieldType.class, (String)"Wrong field type to get quantity total");
        Number tot = ObjectUtils.getTotalNumber(objects, template, fieldName, filter);
        return new Quantity(tot.doubleValue());
    }

    public static Quantity getAverageQty(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, QuantityFieldType.class, (String)"Wrong field type to get quantity average");
        double tot = 0.0;
        MeasureUnit units = MeasureUnitHelper.getMeasureUnitForName((String)"units");
        String scale = units.getScale();
        boolean firstAcceptableQty = true;
        int acceptedCount = 0;
        for (Object o : objects) {
            if (filter != null && !filter.accept(o)) continue;
            Assert.isTrue((boolean)template.objectBelongs(o), (String)("Object <" + o + "> does not belong to template \"" + template + "\""));
            Quantity q = (Quantity)template.getObjectProperty(o, fieldName);
            if (q == null) continue;
            if (firstAcceptableQty) {
                units = q.getMeasureUnit();
                scale = units.getScale();
                firstAcceptableQty = false;
            } else if (!q.getMeasureUnit().getScale().equals(scale)) {
                return null;
            }
            tot += q.getRawValue();
            ++acceptedCount;
        }
        double val = acceptedCount == 0 ? 0.0 : tot / (double)acceptedCount;
        return new Quantity((MeasureUnitI)units, val);
    }

    public static Price getTotalPrice(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, PriceFieldType.class, (String)"Wrong field type to get price total");
        Number tot = ObjectUtils.getTotalNumber(objects, template, fieldName, filter);
        return new Price(tot.doubleValue(), 0.0);
    }

    private static Number getTotalNumber(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        double tot = 0.0;
        for (Object o : objects) {
            if (filter != null && !filter.accept(o)) continue;
            Assert.isTrue((boolean)template.objectBelongs(o), (String)("Object <" + o + "> does not belong to template \"" + template + "\""));
            Number n = (Number)template.getObjectProperty(o, fieldName);
            if (n == null) continue;
            tot += n.doubleValue();
        }
        return new Double(tot);
    }

    public static Price getAveragePrice(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, PriceFieldType.class, (String)"Wrong field type to get price average");
        double total = 0.0;
        int acceptedCount = 0;
        for (Object o : objects) {
            if (filter != null && !filter.accept(o)) continue;
            Assert.isTrue((boolean)template.objectBelongs(o), (String)("Object <" + o + "> does not belong to template \"" + template + "\""));
            Price p = (Price)template.getObjectProperty(o, fieldName);
            total += p.doubleValue();
            ++acceptedCount;
        }
        double val = acceptedCount == 0 ? 0.0 : total / (double)acceptedCount;
        return new Price(val, 0.0);
    }

    public static double getTotalDouble(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, DoubleFieldType.class, (String)"Wrong field type to get double total");
        Number tot = ObjectUtils.getTotalNumber(objects, template, fieldName, filter);
        return tot.doubleValue();
    }

    public static double getAverageDouble(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, DoubleFieldType.class, (String)"Wrong field type to get double average");
        double total = 0.0;
        int acceptedCount = 0;
        for (Object o : objects) {
            if (filter != null && !filter.accept(o)) continue;
            Assert.isTrue((boolean)template.objectBelongs(o), (String)("Object <" + o + "> does not belong to template \"" + template + "\""));
            Double d = (Double)template.getObjectProperty(o, fieldName);
            total += d.doubleValue();
            ++acceptedCount;
        }
        return acceptedCount != 0 ? total / (double)acceptedCount : 0.0;
    }

    public static int getTotalInt(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, IntFieldType.class, (String)"Wrong field type to get int total");
        Number tot = ObjectUtils.getTotalNumber(objects, template, fieldName, filter);
        return tot.intValue();
    }

    public static double getAverageInt(List objects, ObjectTemplate template, String fieldName, ObjectFilter filter) {
        FieldType fieldType = template.getFieldType(fieldName);
        Assert.isInstanceOf((Object)fieldType, IntFieldType.class, (String)"Wrong field type to get int average");
        int total = 0;
        int acceptedCount = 0;
        for (Object o : objects) {
            if (filter != null && !filter.accept(o)) continue;
            Assert.isTrue((boolean)template.objectBelongs(o), (String)("Object <" + o + "> does not belong to template \"" + template + "\""));
            Integer val = (Integer)template.getObjectProperty(o, fieldName);
            total += val.intValue();
            ++acceptedCount;
        }
        return acceptedCount != 0 ? (double)total / (double)acceptedCount : 0.0;
    }

    private ObjectUtils() {
    }

    public static class ObjectAlphabetComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            String str1 = String.valueOf(o1).toLowerCase();
            String str2 = String.valueOf(o2).toLowerCase();
            return str1.compareTo(str2);
        }
    }
}

