/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.gui.adminkit.AdminGuiUtils;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.util.GuiUtils;
import ca.odell.glazedlists.EventList;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import officemate.adminkit.table.GroupedTable;
import officemate.adminkit.table.GroupedTableModel;
import officemate.adminkit.table.QueryTable;
import officemate.adminkit.table.QueryTableModel;
import officemate.components.tableformat.ExcelJTableAdapter;
import ordermate.startup.ConfigureGuiUtilsTask;
import org.apache.commons.collections.CollectionUtils;
import org.jdesktop.swingx.JXDatePicker;

public class OfficeMateAdminGuiUtils
extends AdminGuiUtils {
    public static AbstractTask createConfigTask() {
        return new ConfigureGuiUtilsTask(){

            public AdminGuiUtils constructAdminGuiUtil() {
                return new OfficeMateAdminGuiUtils();
            }
        };
    }

    public static OfficeMateAdminGuiUtils getInstance() {
        AdminGuiUtils instance = AdminGuiUtils.getInstance();
        if (!(instance instanceof OfficeMateAdminGuiUtils)) {
            throw new IllegalStateException("OfficeMateAdminGuiUtils instance is not the expected type! Was:" + instance.getClass());
        }
        return (OfficeMateAdminGuiUtils)instance;
    }

    public int selectIfPossible(JTable table, int row) {
        int rowActuallySelected = -1;
        int rowCount = table.getRowCount();
        if (rowCount > 0) {
            rowActuallySelected = row >= rowCount ? rowCount - 1 : (row < 0 ? 0 : row);
            table.setRowSelectionInterval(rowActuallySelected, rowActuallySelected);
        }
        return rowActuallySelected;
    }

    public Long getSelectedID(QueryTable table, GroupedTable groupedTable) {
        Long id = -1L;
        if (table == null) {
            return id;
        }
        QueryTableModel tableModel = table.getQueryTableModel();
        if (groupedTable != null) {
            GroupedTableModel model = groupedTable.getGroupedTableModel();
            int normalSelRow = model.getOriginalRow(groupedTable.getSelectedRow());
            id = tableModel.getID(normalSelRow);
        } else {
            id = tableModel.getID(table.getSelectedRow());
        }
        return id;
    }

    public int getSelectedTableRow(JTable table, GroupedTable groupedTable) {
        int row = -1;
        if (groupedTable != null) {
            GroupedTableModel model = groupedTable.getGroupedTableModel();
            row = model.getOriginalRow(groupedTable.getSelectedRow());
        } else if (table != null) {
            row = table.getSelectedRow();
        }
        return row;
    }

    public void selectIfPossible(QueryTable table, GroupedTable groupedTable, Long id, int row) {
        int numRows;
        QueryTableModel tableModel = table.getQueryTableModel();
        if (groupedTable != null) {
            numRows = groupedTable.getRowCount();
            GroupedTableModel groupedModel = groupedTable.getGroupedTableModel();
            int originalRow = tableModel.getRow(id);
            int rowToSelect = -1;
            if (originalRow != -1) {
                rowToSelect = groupedModel.getGroupedRow(originalRow);
            } else if (row >= 0 && row < numRows) {
                rowToSelect = groupedModel.getGroupedRow(row);
            } else if (numRows > 0) {
                rowToSelect = 0;
            }
            if (rowToSelect != -1 && rowToSelect < numRows) {
                groupedTable.setRowSelectionInterval(rowToSelect, rowToSelect);
                GuiUtils.scrollToTableRow((JScrollPane)groupedTable.getScroller(), (JTable)((Object)groupedTable), (int)rowToSelect);
            }
        }
        if (table != null) {
            numRows = table.getRowCount();
            int originalRow = tableModel.getRow(id);
            int rowToSelect = -1;
            if (originalRow != -1) {
                rowToSelect = originalRow;
            } else if (row >= 0 && row < numRows) {
                rowToSelect = row;
            } else if (numRows > 0) {
                rowToSelect = 0;
            }
            if (rowToSelect != -1) {
                table.setRowSelectionInterval(rowToSelect, rowToSelect);
                GuiUtils.scrollToTableRow((JScrollPane)table.getScroller(), (JTable)table, (int)rowToSelect);
            }
        }
    }

    public JXDatePicker standardDatePickerSetup(JXDatePicker datePicker) {
        DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        datePicker.setFormats(formats);
        return datePicker;
    }

    public void standardTableSetup(JTable table) {
        new ExcelJTableAdapter(table);
        table.getSelectionModel().setSelectionMode(1);
        table.toString();
    }

    public void standardTreeSetup(JTree tree) {
        tree.toString();
    }

    public void standardSpinnerSetup(JSpinner spinner) {
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)spinner.getEditor();
        final JFormattedTextField textField = editor.getTextField();
        textField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        textField.selectAll();
                    }
                });
            }
        });
    }

    public void standardListSetup(JList list) {
        list.toString();
    }

    public void refreshListWithCollection(EventList listToRefesh, Collection newData) {
        this.refreshList(listToRefesh, new ArrayList(newData));
    }

    public void refreshList(EventList listToRefresh, List newListData) {
        listToRefresh.retainAll((Collection)newListData);
        HashSet removeList = new HashSet(listToRefresh);
        Iterator it = removeList.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            int i = newListData.indexOf(obj);
            if (i == -1) continue;
            Object newObj = newListData.get(i);
            if (obj != newObj) {
                Collections.replaceAll(listToRefresh, obj, newObj);
            }
            it.remove();
        }
        listToRefresh.removeAll(removeList);
        Collection newElements = CollectionUtils.subtract((Collection)newListData, (Collection)listToRefresh);
        listToRefresh.addAll(newElements);
    }

    public static <T> void updateList(EventList<T> toUpdate, List<T> toReadFrom) {
        toUpdate.getReadWriteLock().writeLock().lock();
        toUpdate.clear();
        toUpdate.addAll(toReadFrom);
        toUpdate.getReadWriteLock().writeLock().unlock();
    }
}

