/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit;

import au.com.ordermate.guicore.task.GUIStateI;
import officemate.adminkit.GUIStateTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.RestrictedGUIState;
import officemate.adminkit.tree.ObjectMenu;
import officemate.adminkit.tree.ObjectMenuItem;
import officemate.adminkit.tree.SecurityMenuItem;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class StateMenu
extends ObjectMenu {
    public final Signal stateSelected = Signals.createSignal(GUIStateI.class, (String)"selectedState");
    private GUIStateI rootState;

    public StateMenu(GUIStateI state) {
        super(state, GUIStateTemplate.instance);
        this.rootState = state;
        this.objectSelected.connect((Object)this, "gotObjectSelected");
        this.updateSecurityAccess();
    }

    public void updateSecurityAccess() {
        if (this.rootState instanceof RestrictedGUIState) {
            RestrictedGUIState restrictedState = (RestrictedGUIState)this.rootState;
            String access = restrictedState.getAccessLevel();
            if (access.equals("HIDDEN")) {
                this.setEnabled(false);
                this.setVisible(false);
            } else if (access.equals("DISABLED")) {
                this.setEnabled(false);
                this.setVisible(true);
            } else if (access.equals("ENABLED")) {
                this.setEnabled(true);
                this.setVisible(true);
            }
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateSecurityAccess();
    }

    @Override
    protected ObjectMenuItem createObjectMenuItem(Object userObject) {
        ObjectMenuItem menuItem;
        GUIStateI state = (GUIStateI)userObject;
        if (userObject instanceof RestrictedGUIState) {
            RestrictedGUIState restrictedState = (RestrictedGUIState)userObject;
            menuItem = new SecurityMenuItem((Object)restrictedState, restrictedState.getAccessPermission());
        } else {
            menuItem = super.createObjectMenuItem(userObject);
        }
        menuItem.setToolTipText(state.getDescription());
        if (state instanceof BasicOfficeMateState) {
            BasicOfficeMateState adminState = (BasicOfficeMateState)state;
            menuItem.setIcon(adminState.getSmallIcon());
        }
        return menuItem;
    }

    @Override
    protected ObjectMenu createObjectMenu(Object userObject, ObjectFilter menuFilter) {
        GUIStateI state = (GUIStateI)userObject;
        StateMenu menu = new StateMenu(state);
        menu.setToolTipText(state.getDescription());
        if (state instanceof BasicOfficeMateState) {
            BasicOfficeMateState adminState = (BasicOfficeMateState)state;
            menu.setIcon(adminState.getSmallIcon());
        }
        return menu;
    }

    void gotObjectSelected(Object obj) {
        GUIStateI state;
        if (obj instanceof GUIStateI && !(state = (GUIStateI)obj).hasSubStates()) {
            this.stateSelected.emit(obj);
        }
    }
}

