/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.columnformats;

import java.text.DecimalFormat;
import java.text.Format;
import javax.swing.table.TableCellRenderer;
import officemate.adminkit.cellrenderers.CurrencyColumnRenderer;
import officemate.components.tableformat.ColumnTableFormat;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;

public class DiscountColumnFormat
extends ColumnTableFormat {
    private static final String COLUMN_TARGET = "Target";
    private static final String COLUMN_DISCOUNT = "Discount";
    private static final String COLUMN_COST = "Cost";
    private static final String COLUMN_TYPE = "Type";
    private static final String CURRENCY_FORMAT = "##,##,###.00";

    public DiscountColumnFormat() {
        this.addColumn(COLUMN_TARGET);
        this.addColumn(COLUMN_DISCOUNT);
        this.addColumn(COLUMN_COST);
        this.addColumn(COLUMN_TYPE);
    }

    private void addColumn(final String columnName) {
        AbstractColumnFormat abstractColumnFormat = new AbstractColumnFormat(columnName, String.class){

            public Object resolveColumnValue(Object baseObject) {
                return DiscountColumnFormat.this.getColumnValue(baseObject, columnName);
            }
        };
        if (columnName.equals(COLUMN_COST)) {
            abstractColumnFormat.setFormatter((Format)new DecimalFormat(CURRENCY_FORMAT));
            abstractColumnFormat.setCustomRenderer((TableCellRenderer)new CurrencyColumnRenderer());
        }
        super.addColumn((ColumnFormat)abstractColumnFormat);
    }

    private String getColumnValue(Object baseObject, String columnName) {
        if (baseObject instanceof AdjustmentsReport) {
            AdjustmentsReport adjustmentsReport = (AdjustmentsReport)baseObject;
            if (columnName.equals(COLUMN_DISCOUNT)) {
                return adjustmentsReport.getName();
            }
            if (columnName.equals(COLUMN_COST)) {
                return adjustmentsReport.getSavedTotal().toString();
            }
            if (columnName.equals(COLUMN_TYPE)) {
                return adjustmentsReport.getType().toString();
            }
            if (columnName.equals(COLUMN_TARGET)) {
                return adjustmentsReport.getTarget();
            }
        } else if (baseObject instanceof SalesPriceAdjustment) {
            SalesPriceAdjustment spa = (SalesPriceAdjustment)baseObject;
            if (columnName.equals(COLUMN_DISCOUNT)) {
                return spa.getLabel();
            }
            if (columnName.equals(COLUMN_COST)) {
                return spa.getValue().toString();
            }
            if (columnName.equals(COLUMN_TYPE)) {
                return spa.getType().getLabel();
            }
            if (columnName.equals(COLUMN_TARGET) && spa.getLevel().equals((Object)PriceAdjustmentLevel.ACCOUNT_LEVEL)) {
                return spa.getAccount().getType();
            }
        }
        return "";
    }
}

