/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.dialogs;

import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.Task;
import java.awt.Container;
import java.awt.Frame;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import officemate.adminkit.dialogs.ErrorDetailPanel;
import officemate.adminkit.dialogs.LinkPanel;
import officemate.adminkit.dialogs.OkCancelDialog;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.adminkit.dialogs.OptionPanel;
import ordermate.OrderMate;
import ordermate.gui.dialogs.ProgressDialog;
import ordermate.reports.dynamicjasper.reportbuilder.ReportProvider;
import ordermate.signals.Signal;

public class Dialogs {
    private static JFrame owner;

    private Dialogs() {
    }

    public static void setup(JFrame theOwner) {
        owner = theOwner;
    }

    public static boolean showMessageDialog(String title, String message, int messageType, boolean showOK, boolean showCancel) {
        Object toShow = message;
        if (message.startsWith("<html>")) {
            toShow = new JLabel(message);
        }
        if (showOK && showCancel) {
            return 0 == JOptionPane.showConfirmDialog(owner, toShow, title, 2, messageType);
        }
        if (showOK) {
            JOptionPane.showMessageDialog(owner, toShow, title, messageType);
            return true;
        }
        throw new IllegalArgumentException("Illegal combination of button visibility");
    }

    public static boolean showChoiceDialog(String title, String message) {
        return Dialogs.showMessageDialog(title, message, 3, true, true);
    }

    public static void showMessageDialog(String title, String message) {
        Dialogs.showMessageDialog(title, message, 1, true, false);
    }

    public static void showInfoDialog(String title, String message) {
        Dialogs.showMessageDialog(title, message, 1, true, false);
    }

    public static void showErrorDialog(String title, String message) {
        Dialogs.showMessageDialog(title, message, 0, true, false);
    }

    public static boolean showWarningDialog(String title, String message) {
        return Dialogs.showMessageDialog(title, message, 2, true, true);
    }

    public static Object showOptionDialog(String title, String message, Collection options) {
        OptionPanel panel = new OptionPanel(options);
        OkCancelDialogBuilder builder = Dialogs.getOkCancelDialogBuilder(panel);
        builder.setTitle(title).setHtmlHeader(message);
        if (builder.doShow()) {
            return panel.getSelectedOption();
        }
        return null;
    }

    public static void showLinkDialog(String title, String message, URI address, String linkDisplayText) {
        LinkPanel linkPanel = new LinkPanel(message, address, linkDisplayText);
        OkCancelDialogBuilder builder = Dialogs.getOkCancelDialogBuilder(linkPanel);
        builder.setTitle(title).setOkSignal(linkPanel.getLinkSignal()).hideCancel();
        builder.doShow();
    }

    public static void showErrorDetailDialog(String title, String message, String error) {
        ErrorDetailPanel panel = new ErrorDetailPanel(message, error);
        JOptionPane.showMessageDialog(owner, panel, title, 0);
    }

    public static boolean showProgressDialog(AbstractTask task) {
        ProgressDialog dialog = new ProgressDialog((Frame)owner, true, (Task)task);
        return dialog.start();
    }

    public static ProgressDialog createProgressDialog(AbstractTask task) {
        ProgressDialog dialog = new ProgressDialog((Frame)owner, true, (Task)task);
        return dialog;
    }

    public static void showJasperPrintDialog(ReportProvider provider) {
        Dialogs.showJasperPrintDialog(provider, null, false);
    }

    public static void showJasperPrintDialog(final ReportProvider provider, JFrame parentFrame, boolean modal) {
        JDialog reportDisplay = new JDialog((Frame)parentFrame, modal);
        final AtomicReference printRef = new AtomicReference();
        AbstractTask task = new AbstractTask(){

            public String getName() {
                return "Create report";
            }

            protected void performTask() throws Exception {
                try {
                    printRef.set(provider.getReportPrint());
                    this.done.emit();
                }
                catch (JRException e) {
                    OrderMate.LOG.error("Unable to generate report.", (Throwable)e);
                    throw e;
                }
            }

            protected int getTotalSubTasks() {
                return 1;
            }
        };
        boolean success = Dialogs.showProgressDialog(task);
        JasperPrint print = (JasperPrint)printRef.get();
        if (success && print != null) {
            JRViewer viewer = new JRViewer(print);
            viewer.setFitWidthZoomRatio();
            reportDisplay.setContentPane((Container)viewer);
            reportDisplay.setSize(800, 600);
            reportDisplay.setVisible(true);
        } else {
            Dialogs.showInfoDialog("No report to display.", "There are no items in the current filtered table");
        }
    }

    public static boolean showOkCancelCustomDialog(String title, String headerHtml, JComponent component) {
        return Dialogs.showOkCancelCustomDialog(title, headerHtml, component, true, null);
    }

    public static boolean showOkCancelCustomDialog(String title, String headerHtml, JComponent component, Signal okSignal) {
        return Dialogs.showOkCancelCustomDialog(title, headerHtml, component, true, okSignal);
    }

    public static boolean showOkCustomDialog(String title, String headerHtml, JComponent component) {
        return Dialogs.showOkCancelCustomDialog(title, headerHtml, component, false, null);
    }

    private static boolean showOkCancelCustomDialog(String title, String headerHtml, JComponent component, boolean showCancelBtn, Signal okSignal) {
        OkCancelDialog dialog = new OkCancelDialog(showCancelBtn);
        dialog.setTitle(title);
        dialog.setHeaderHtml(title, headerHtml);
        dialog.setMainComponent(component);
        if (okSignal != null) {
            dialog.setOkSignal(okSignal);
        }
        boolean result = dialog.doModal();
        dialog.dispose();
        return result;
    }

    public static OkCancelDialogBuilder getOkCancelDialogBuilder(JComponent component) {
        return new OkCancelDialogBuilder(component);
    }
}

