/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.dialogs;

import au.com.ordermate.application.GuiApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import officemate.adminkit.dialogs.OkCancelDialogHandler;
import ordermate.signals.Signal;
import org.jdesktop.swingx.JXHeader;

class OkCancelDialog
extends JDialog
implements ActionListener {
    private JButton okBut;
    private JButton cancelBut;
    private JPanel holder;
    private boolean okPressed = false;
    private JXHeader header;
    private OkCancelDialogHandler handler;
    private Signal okSignal;
    private boolean allowCancel = true;

    OkCancelDialog() {
        super(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        this.setModal(true);
        this.setupComponents();
    }

    OkCancelDialog(boolean allowCancel) {
        super(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        this.allowCancel = allowCancel;
        this.setModal(true);
        this.setupComponents();
    }

    private void setupComponents() {
        JPanel butHolder = new JPanel(new FlowLayout(2));
        this.okBut = this.setupButton("OK");
        butHolder.add(this.okBut);
        if (this.allowCancel) {
            this.cancelBut = this.setupButton("Cancel");
            butHolder.add(this.cancelBut);
        }
        this.getContentPane().add((Component)butHolder, "South");
        this.holder = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)this.holder, "Center");
        JPanel headerPane = new JPanel();
        headerPane.setLayout(new BoxLayout(headerPane, 3));
        this.header = new JXHeader();
        headerPane.add((Component)this.header);
        headerPane.add(new JSeparator());
        this.add((Component)headerPane, "First");
    }

    void setHeaderHtml(String title, String desc) {
        this.header.setTitle(title);
        this.header.setDescription(desc);
    }

    void setHeaderHtml(String html) {
        this.header.setDescription(html);
    }

    void setHeaderTitle(String title) {
        this.header.setTitle(title);
    }

    void setShowCancelBtn(boolean show) {
        this.allowCancel = show;
        this.cancelBut.setVisible(show);
    }

    private JButton setupButton(String label) {
        JButton button = new JButton(label);
        button.addActionListener(this);
        return button;
    }

    void setMainComponent(JComponent component) {
        this.holder.removeAll();
        this.holder.add((Component)component, "Center");
        this.holder.invalidate();
        this.pack();
    }

    @Override
    public void setVisible(boolean value) {
        if (value) {
            this.okPressed = false;
        } else if (this.okSignal != null) {
            this.okSignal.disconnect((Object)this);
        }
        super.setVisible(value);
    }

    boolean wasOkPressed() {
        return this.okPressed;
    }

    boolean doModal() {
        this.okPressed = false;
        this.pack();
        Dimension size = this.getSize();
        double screenHeight = Toolkit.getDefaultToolkit().getScreenSize().getHeight();
        int frameHeight = this.getParent().getHeight();
        if ((double)size.height > screenHeight) {
            this.setSize(this.getWidth(), (int)screenHeight - 50);
        } else if (size.height > frameHeight) {
            this.setSize(this.getWidth(), frameHeight - 20);
        }
        this.setLocationRelativeTo(this.getParent());
        this.setVisible(true);
        return this.wasOkPressed();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        boolean okToClose = false;
        if (source == this.okBut && (this.handler == null || this.handler.isOKAllowed())) {
            this.okPressed = true;
            okToClose = true;
        } else if (source == this.cancelBut && (this.handler == null || this.handler.isCancelAllowed())) {
            okToClose = true;
        }
        if (okToClose) {
            this.setVisible(false);
        }
    }

    void setOkSignal(Signal signal) {
        if (this.okSignal != null) {
            this.okSignal.disconnect((Object)this);
        }
        this.okSignal = signal;
        signal.connect((Object)this, "doOkSignal");
    }

    private void doOkSignal() {
        this.okPressed = true;
        this.setVisible(false);
    }

    @Override
    public void dispose() {
        this.holder.removeAll();
        super.dispose();
    }

    public void setHandler(OkCancelDialogHandler handler) {
        this.handler = handler;
    }
}

