/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.util.Assert;
import java.awt.Component;
import java.awt.Dimension;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JComponent;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.DateFieldType;
import officemate.adminkit.types.FieldType;
import org.jdesktop.swingx.JXDatePicker;

public class DateFieldPanel
extends FieldPanel {
    private JXDatePicker dateChooser;
    private DateFieldType fieldType;
    private boolean allowNull;

    public DateFieldPanel(boolean newAllowNull) {
        DateFormat[] formats = new DateFormat[]{new SimpleDateFormat("dd/MM/yyyy")};
        this.allowNull = newAllowNull;
        this.dateChooser = new JXDatePicker();
        this.dateChooser.setFormats(formats);
        Dimension size = this.dateChooser.getPreferredSize();
        size.width += 50;
        this.dateChooser.setPreferredSize(size);
        this.add((Component)this.dateChooser);
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener(this));
        this.getPrimaryComponent().addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        return this.dateChooser.getDate();
    }

    @Override
    public void setValue(Object obj) {
        Object value = obj;
        if (value == null && this.allowNull) {
            value = new Date();
        } else if (value == null) {
            throw new IllegalArgumentException("Cannot handle null dates");
        }
        Assert.isTrue((boolean)(value instanceof Date), (String)("Expecting java.util.Date, found " + value.getClass().getName()));
        this.dateChooser.setDate((Date)value);
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (DateFieldType)fType;
        this.setValue(this.fieldType.getDefaultInitValue());
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.dateChooser;
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.dateChooser.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.dateChooser.setEnabled(b);
    }
}

