/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.FieldType;

public class DoubleFieldPanel
extends FieldPanel {
    private DoubleFieldType fieldType;
    private SpinnerNumberModel spinnerModel;
    private JSpinner spinner;
    private JTextField textField;

    public DoubleFieldPanel() {
        this.setLayout(new BorderLayout());
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        this.updateSpinner();
        return this.spinnerModel.getNumber();
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }

    private void updateSpinner() {
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException e) {
            this.spinner.setValue(this.spinnerModel.getValue());
        }
    }

    @Override
    public void setValue(Object o) {
        double val = (Double)o;
        Double max = this.fieldType.getMaxValue();
        Double min = this.fieldType.getMinValue();
        if (min != null && val < min) {
            val = min;
        } else if (max != null && val > max) {
            val = max;
        }
        this.spinner.setValue(new Double(val));
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (DoubleFieldType)fType;
        Double minObj = this.fieldType.getMinValue();
        Double maxObj = this.fieldType.getMaxValue();
        Double defObj = this.fieldType.getDefaultValue();
        double min = minObj != null ? minObj : -1.0E7;
        double max = maxObj != null ? maxObj : 1.0E7;
        double def = defObj != null ? defObj : 0.0;
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        if (this.spinner != null) {
            innerPanel.remove(this.spinner);
        }
        this.spinnerModel = new SpinnerNumberModel(def, min, max, 1.0);
        this.spinner = new JSpinner(this.spinnerModel);
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        this.textField = editor.getTextField();
        this.textField.setColumns(20);
        this.textField.addFocusListener(new FieldPanel.InnerPrimaryFocusListener(this));
        this.spinner.setPreferredSize(new Dimension(70, 20));
        innerPanel.add((Component)this.spinner, "North");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridLayout(1, 3));
        innerPanel.add((Component)buttonPanel, "South");
        this.add((Component)innerPanel, "North");
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener(this));
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.textField;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.spinner.setEnabled(b);
        this.textField.setEnabled(b);
    }
}

