/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.util.Pair;
import java.awt.GridLayout;
import javax.swing.JComponent;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.ObjectManagerFieldPanel;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.KVPairFieldType;
import ordermate.OrderMate;

public class IndividualKVPairFieldPanel
extends ObjectManagerFieldPanel {
    private KVPairFieldType fieldType;
    private ObjectEditorPanel editor;

    public IndividualKVPairFieldPanel(ObjectManager manager) {
        super(manager);
        this.setLayout(new GridLayout());
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        this.editor.saveObject();
        return this.editor.getEditedObject();
    }

    @Override
    public void setValue(Object o) {
        this.refreshEditPanel((Pair)o);
    }

    @Override
    public void setFieldType(FieldType fType) {
        this.fieldType = (KVPairFieldType)fType;
        this.refreshEditPanel((Pair)this.fieldType.getDefaultInitValue());
    }

    private void refreshEditPanel(Pair newValue) {
        if (this.editor != null) {
            this.remove(this.editor);
            this.editor.okKeyPressed.disconnect((Object)this.okPressed);
            this.editor.cancelKeyPressed.disconnect((Object)this.cancelPressed);
        }
        Class objectEditorClass = this.fieldType.getKVPairEditorClass();
        ReflectiveOperationException error = null;
        try {
            this.editor = (ObjectEditorPanel)objectEditorClass.newInstance();
            this.editor.init(this.getObjectManager(), this.fieldType.getKVPairTemplate(), newValue);
            this.editor.okKeyPressed.connect((Object)this.okPressed, "emit");
            this.editor.cancelKeyPressed.connect((Object)this.cancelPressed, "emit");
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        catch (InstantiationException e) {
            error = e;
        }
        if (error != null) {
            OrderMate.LOG.error("Couldn't create object editor panel " + objectEditorClass.getName() + " for " + this.fieldType + " <" + this.fieldType.getKeyType() + ", " + this.fieldType.getValueType() + ">", (Throwable)error);
        }
        this.add(this.editor);
    }

    void gotOK() {
        this.editor.saveObject();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.editor.setEnabled(b);
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.editor;
    }
}

